/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart;

import java.io.Serializable;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.graphics.geom.RectShape;
import org.afree.util.ObjectUtilities;
import org.afree.util.PublicCloneable;

public class ChartRenderingInfo
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 2751952018173406822L;
    private transient RectShape chartArea = new RectShape();
    private PlotRenderingInfo plotInfo = new PlotRenderingInfo(this);
    private EntityCollection entities;

    public ChartRenderingInfo() {
        this(new StandardEntityCollection());
    }

    public ChartRenderingInfo(EntityCollection entities) {
        this.entities = entities;
    }

    public RectShape getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(RectShape area) {
        this.chartArea.setRect(area);
    }

    public EntityCollection getEntityCollection() {
        return this.entities;
    }

    public void setEntityCollection(EntityCollection entities) {
        this.entities = entities;
    }

    public void clear() {
        this.chartArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.plotInfo = new PlotRenderingInfo(this);
        if (this.entities != null) {
            this.entities.clear();
        }
    }

    public PlotRenderingInfo getPlotInfo() {
        return this.plotInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChartRenderingInfo)) {
            return false;
        }
        ChartRenderingInfo that = (ChartRenderingInfo)obj;
        if (!ObjectUtilities.equal(this.chartArea, that.chartArea)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.plotInfo, that.plotInfo)) {
            return false;
        }
        return ObjectUtilities.equal(this.entities, that.entities);
    }

    public Object clone() throws CloneNotSupportedException {
        ChartRenderingInfo clone = (ChartRenderingInfo)super.clone();
        if (this.chartArea != null) {
            clone.chartArea = this.chartArea.clone();
        }
        if (this.entities instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)((Object)this.entities);
            clone.entities = (EntityCollection)pc.clone();
        }
        return clone;
    }
}

