#include <kernel.h>
#include <t_syslog.h>
#include <t_stdlib.h>
#include "kernel_cfg.h"
#include "app.h"
#include "lpc17xx_gpio.h"

/*
 *  サービスコールのエラーのログ出力
 */
Inline void
svc_perror(const char *file, int_t line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_ERROR, file, line, expr, ercd);
	}
}

#define	SVC_PERROR(expr)	svc_perror(__FILE__, __LINE__, #expr, (expr))

	/* LPCXpresso 1768/1769では、GPIO0のbit22がLEDに接続されている */
#define LEDMASK	(1<<22)

/*
 *  メインタスク
 */
void main_task(intptr_t exinf)
{

	syslog(LOG_NOTICE, "Sample program starts (exinf = %d).", (int_t) exinf);

		/* GPIO0のLED制御ピンを出力にする */
	GPIO_SetDir(
			0,			// GPIOポート番号
			LEDMASK,	// 操作するビットマスク
			1			// 設定する値
			);

	while(1)
	{
			/* 500m秒待つ */
		SVC_PERROR(tslp_tsk(500));
			/* LED制御ピンをLにする */
		GPIO_ClearValue(
				0,			// GPIOポート番号
				LEDMASK	// 操作するビットマスク
				);
			/* 500m秒待つ */
		SVC_PERROR(tslp_tsk(500));
			/* LED制御ピンをHにする */
		GPIO_SetValue(
				0,			// GPIOポート番号
				LEDMASK	// 操作するビットマスク
				);
	}


	syslog(LOG_NOTICE, "Sample program ends.");
	SVC_PERROR(ext_ker());
	assert(0);
}
