/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertDetectedForm.cs#15 $
 * $DateTime: 2008/01/28 14:36:17 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Resources;
using System.Drawing;
using System.Media;

using Poderosa.Commands;
using Travis.LocationOperation;

using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Ordering;
using Bellagio.Drawing;

using Sansa.Runtime;


namespace Bellagio.Alert {
    public class AlertDetectedForm : Form, ChartControl.IChartControlCustomize, ITickListener {

        //Piځ@^Cg
        private Label _icon; //ACR
        private Label _mainLabel; //oCxg̃CeLXg
        private Label _detailedLabel; //AȂ

        //Qiځ@vCp`[gƔ
        private ChartControl _chart;
        private ChartDrawingSettings _chartDrawingSettings;
        //private ItaControl _ita;

        //Riځ@{^
        private RibbonMenuButton _orderButton;
        private RibbonMenuButton _closeButton;
        //private RibbonMenuButton _replayButton;

        //zu
        private RectOp _rectOperator;
        private BRect _replayPicturePosition;

        //ZbeBO
        private Color _replayTriangleColor;
        //private int _replaySpeedRatio; //vC͌Ԃ̉{Őiނ

        //NOTE vC@\͏
        //vCf[^
        //@vC邽߂ɁÃtH[Ƀ[JQuoteRealTimeChartDocumentpӂBʏ̂悤ɂ
        //@DataSubscriberɐڑ̂ł͂ȂÃtH[Ƀ[J̃^C}[gTickƔ𗬂Ă
        private AlertData _alertData; //̓A[gʒm\z邽߂̂
        private IntraDayTrade _localIntraDayTrade; //vCp[Jɂ킹āA_alertData_localQuoteɃf[^Rs[Ă
        private ExternalIntraDayTradeChartDocument _localChartDocument;
        //private int _populatedTickCount; //C|[gς݂Tick
        private BTime _replayTime; //vC̎
        //private IntTimer _timer; //vC𓮍삳邽߂̃^C}[

        //TODO Timer.Abort͏IlɃWvĂɔtickĂB̃_CAOł͂ł͕ssAƂ肠tOŉBClose𓱓ׂ
        //private bool _closing;

        public AlertDetectedForm(AlertData data) {
            StaticInit();
            _replayPicturePosition = new BRect();
            _replayTriangleColor = Color.FromArgb(0xCC, 0, 0);
            

            _alertData = data;
            _localIntraDayTrade = _alertData.CreateNewIntraDayTrade();
            _localIntraDayTrade.UpdateByTicks(_alertData.TickData);
            _replayTime = new BTime(_alertData.AlertTime);
            _localChartDocument = new ExternalIntraDayTradeChartDocument(_localIntraDayTrade, 1);
            _localChartDocument.ConstructWithSchema(GetChartSchema());
            _localChartDocument.SetOscillatorVisible(false);
            _chartDrawingSettings = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;
            
            //_timer = new IntTimer(BellagioPlugin.Instance.SansaPlatform, new DTimerHandler(new DTimerHandler.D(ResetReplayTimer), new DTimerHandler.D(TickReplayTimer)));

            this.SuspendLayout();
            this.ShowInTaskbar = false;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.Manual;
            this.FormBorderStyle = FormBorderStyle.FixedDialog;
            this.Font = new Font("lr SVbN", 9F);

            _icon = FormUtil.CreateImageLabel(BellagioRoot.CommonIcons.LargeSessions.GetBitmap(6));
            _mainLabel = FormUtil.CreateLabel(String.Format("A[gʒm {0}", _alertData.SourceCondition.Title));
            this.Text = _mainLabel.Text;
            _mainLabel.Font = new Font("MS UI Gothic", 11F);
            _detailedLabel = FormUtil.CreateLabel(String.Format(" {0}     {1}", _alertData.Stock.Profile.Name, BTime.FormatHHMMSS(_alertData.AlertTime)));
            _detailedLabel.Font = new Font("MS UI Gothic", 10F);
            _chart = new ChartControl(_localChartDocument, _chartDrawingSettings, this);
            ChartDrawing.LocalSettings ls = _chart.ChartDrawing.ChartLocalSettings;
            ls.drawHeader = false;
            ls.enableFigureDrawing = false;
            ls.enableMouseTrackingLine = false;
            
            _chart.SetCurrentStock(_alertData.Stock);
            _orderButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(0), new MouseEventHandler(OnOrderButtonClick));
            _closeButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(1), new MouseEventHandler(OnCloseButtonClick));
            _closeButton.DialogResult = DialogResult.OK;
            //_replayButton = FormUtil.CreateRibbonCommandButton("vC", LargeBitmap(15), new MouseEventHandler(OnReplayButtonClick));

            this.Controls.AddRange(new Control[] {
                _icon, _mainLabel, _detailedLabel, _chart, /*_ita*/ _orderButton, _closeButton, /*_replayButton*/});

            int cmd_h = 52;
            int cmd_w = 52;
            _rectOperator = new RectangleOperatorBuilder(0)
                .SplitTop(64).PlaceControl(ContentAlignment.TopLeft, _icon, 32, 32).RightControl(_mainLabel, 300, 24)
                    .BottomControl(_detailedLabel, 300, 32).CloseBranch()
                .SplitFixed(SplitDir.Bottom, cmd_h+8)
                    .SetMargin(4)
                    .Tee()
                        .PlaceControl(ContentAlignment.TopLeft, _orderButton, cmd_w, cmd_h)
                        .CloseBranch()
                    //.CornerOffset(RectCorner.TopRight, -8-cmd_w, 0, cmd_w, cmd_h).ProbeControl(_replayButton).LocateSide(SplitDir.Left, 8, cmd_w, cmd_h).ProbeControl(_closeButton)
                    .PlaceControl(ContentAlignment.BottomRight, _closeButton, cmd_w, cmd_h)
                    .CloseBranch()
                    .ProbeControl(_chart)
                .Finish();

            this.ClientSize = new Size(500, 408);
            _rectOperator.Rect(this.ClientRectangle);

            this.ResumeLayout();

            BellagioPlugin.Instance.SansaPlatform.AssureStart();
            BellagioPlugin.Instance.SansaPlatform.getRootTimer().addTickListener(this);
            
            if(_alertData.SourceCondition.SoundFile!=null) {
                SoundPlayer sp = new SoundPlayer(_alertData.SourceCondition.SoundFile);
                sp.Play();
            }
        }
        protected override void OnClosed(EventArgs e) {
            base.OnClosed(e);
            BellagioPlugin.Instance.SansaPlatform.getRootTimer().removeTickListener(this);
        }
        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                //_closing = true;
                //_timer.Abort();
                _chart.Dispose(); //chartDrawingDisposêOK
            }
        }

        private void OnOrderButtonClick(object sender, EventArgs args) {
            OrderFormParameter info = OrderFormParameter.ForNewPosition(_alertData.Stock.Profile);
            
            OrderingPlugin.Instance.Commands.OpenOrderFormCommand((ICommandTarget)this.Owner, info);
        }
        private void OnCloseButtonClick(object sender, EventArgs args) {
            this.Close();
        }
        /*
        private void OnReplayButtonClick(object sender, EventArgs args) {
            _timer.Abort();

            ResetReplayData();
            _localDaytimeTrade.Reset();
            _localDaytimeTrade.ResetByQuote(_alertData.Quote); //P̂Ƃ́A_localChartDocumentĂPriceRecord_localQuoteQuoteƓIuWFNgȂ̂łł悢B
            _localChartDocument.ResetSectionInfo();
            _chart.ChartDrawing.DisplayPosition = _localChartDocument.SectionInfo.LastPosition;
            _timer.Initialize();
            _chart.Invalidate();
        }

        private void ResetReplayData() {
            Candle y = _alertData.Quote.LastCandle;
            _replayTime = y==null? new BTime(MarketUtil.GetZenbaOpenTime(_alertData.Stock.Market)) : new BTime(y.Time);
            _localChartDocument.ResetSectionInfo();
            _populatedTickCount = 0;
        }
        //Timer
        private void ResetReplayTimer() {
            Candle y = _alertData.Quote.LastCandle;
            int start = y==null? MarketUtil.GetZenbaOpenTime(_alertData.Stock.Market).AsInt() : y.Time;
            int end = _alertData.AlertTime.AsInt();
            //ʏ͂Pb\tick͂B10{\łPbtickŕ\̂łPbPʂœƂɂȂ
            _timer.reset(start, end, BellagioPlugin.Instance.SansaPlatform.getRootTimer().secondToTick((end-start)/_replaySpeedRatio));
        }
        private void TickReplayTimer() {
            if(_closing) return;

            TimeAndSales src_ts = _alertData.TickData;
            int added_count = 0;
            bool second_changed = _replayTime.AsInt() != _timer.value(); //bςwb_邽Invalidate
            
            _replayTime.LetInt(_timer.value());

            while(_populatedTickCount < src_ts.Count && src_ts.TickAt(_populatedTickCount).Time <= _timer.value()) {
                _localDaytimeTrade.UpdateBySingleTick(src_ts.TickAt(_populatedTickCount++));
                added_count++;
            }
            _localDaytimeTrade.UpdateByTime(_replayTime);

            if(added_count > 0)
                _chart.RealTimeDataHandler(); //Ń`[g̃Aj[VX^[g
            if(second_changed)
                _chart.Invalidate();
        }
        */
        private bool IsReplayFinised() {
            return true; // !_timer.IsActive();
        }

        private ChartSchema GetChartSchema() {
            //ʏ̕
            return BellagioRoot.SchemaRoot.FindRealTimeChartSchema("tactico.minutely-default");
        }

        //`[g`̕⏕
        void ChartControl.IChartControlCustomize.AdjustRectangleOperator(RectangleOperatorBuilder bld) {
            //bld.SplitFixed(SplitDir.Bottom, _replayPicture.Height+4).ProbeBRect(_replayPicturePosition).CloseBranch();
        }

        string ChartControl.IChartControlCustomize.FormatHeaderText(Stock stock) {
            return "";// return String.Format("A[gO̓({0}{) - {1}", _replaySpeedRatio, BTime.FormatHHMMSS(_replayTime));
        }

        void ChartControl.IChartControlCustomize.CustomPaint(PaintEventArgs args) {
            /*
            Rectangle r = new Rectangle(_replayPicturePosition.Right-_replayPicture.Width-8, _replayPicturePosition.Top+2, _replayPicture.Width, _replayPicture.Height);
            if(r.IntersectsWith(args.ClipRectangle) && !IsReplayFinised()) {
                Graphics g = args.Graphics;
                g.DrawImage(_replayPicture, r.Location);

                //`
                int tickcount = BellagioPlugin.Instance.SansaPlatform.getRootTimer().getTick();
                for(int i=0; i<5; i++) {
                    const int interval= 40;
                    DrawReplayTriangle(g, r.Left + 64 + 7*i, r.Top + 6, ((tickcount+interval-6*i) % interval) / (double)interval);
                }
            }
            */
        }
        private void DrawReplayTriangle(Graphics g, int x, int y, double progress) {
            Color f = _replayTriangleColor;
            Color b = _chart.BackColor;
            Color col;
            Rectangle r = new Rectangle(x, y, 7, 9);

            if(progress < 0.125)
                col = DrawingUtil.ProportionalColor(b, f, progress * 8);
            else if(progress < 0.5)
                col = f;
            else if(progress < 0.625)
                col = DrawingUtil.ProportionalColor(f, b, (progress-0.5) * 8);
            else
                col = b;

            TriangleUtil.FillSmooth(g, r, col, b, TriangleUtil.Direction.Right);
        }
        //SansaTickɂInvalidate
        void ITickListener.beforeTick() {
        }

        void ITickListener.afterTick() {
            if(this.Visible)
                _chart.Invalidate(_replayPicturePosition.Value);
        }


        private static Bitmap _replayPicture;

        private static void StaticInit() {
            if(_replayPicture!=null) return;

            ResourceManager rm = new ResourceManager("Bellagio.Images", typeof(AlertDetectedForm).Assembly);
            _replayPicture = (Bitmap)rm.GetObject("replay");
        }
        private static Bitmap LargeBitmap(int index) {
            //ACR͂قƂǔp̂ƂȂ
            return OrderingPlugin.OrderingIcons.GetBitmap(index);
        }


    }
}
