/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertData.cs#7 $
 * $DateTime: 2007/10/25 12:56:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Values;
using Bellagio.Data;

namespace Bellagio.Alert {
    public class AlertData {
        private Stock _stock;
        private BTime _alertTime;
        private RuntimeAlertCondition _sourceCondition;

        private ConcreteQuote _quote; //tickDataJn܂ł̂S{l
        private TimeAndSales _tickData; //priceRecordIォTick
        private ItaHistory _itaHistory; //

        public AlertData(RuntimeAlertCondition condition, Stock stock, BTime time, ConcreteQuote rec, TimeAndSales ticks, ItaHistory ita_history) {
            _sourceCondition = condition;
            _stock = stock;
            _alertTime = time;
            _quote = rec;
            _tickData = ticks;
            _itaHistory = ita_history;
        }

        public RuntimeAlertCondition SourceCondition {
            get {
                return _sourceCondition;
            }
        }

        public Stock Stock {
            get {
                return _stock;
            }
        }
        public ConcreteQuote Quote {
            get {
                return _quote;
            }
        }
        public TimeAndSales TickData {
            get {
                return _tickData;
            }
        }
        public ItaHistory ItaHistory {
            get {
                return _itaHistory;
            }
        }
        public BTime AlertTime {
            get {
                return _alertTime;
            }
        }

        public IntraDayTrade CreateNewIntraDayTrade() {
            IntraDayTrade q = new IntraDayTrade(_stock);
            if(_quote!=null) {
                Debug.Assert(_quote.Scale==1);
                q.ResetByQuote(_quote);
            }
            return q;
        }
    }
}
