using System;
using System.Collections;
using System.IO;
using System.Xml;

using SystemNeo.Xml;

using NUnit.Framework;

namespace SystemNeoTest.Xml.XmlTreeManagerTest
{
	[TestFixture]
	public class FindNext
	{
		private XmlDocument doc;

		[SetUp]
		public void SetUp()
		{
			const string xml = @"<root>"
			                 + @"<country name='Japan'><city name='Tokyo'/><city name='Osaka'/></country>"
							 + @"<country name='China'><city name='Beijing'/><city name='Hong Kong'/></country>"
			                 + @"</root>";
			this.doc = new XmlDocument();
			this.doc.LoadXml(xml);
		}

		[Test]
		public void g}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']");
			Func<XmlNode, bool> match = (node) => {
				return node.Name == "country" && node.Attributes["name"].Value == "Japan";
			};

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			Assert.Null(result);
		}

		[Test]
		public void q}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']");
			Func<XmlNode, bool> match = (node) => {
				return node.Name == "city" && node.Attributes["name"].Value == "Osaka";
			};

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			XmlNode osakaNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");
			Assert.AreSame(osakaNode, result);
		}

		[Test]
		public void gƒ킪}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Tokyo']");
			Func<XmlNode, bool> match = (node) => node.Name == "city";

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			XmlNode osakaNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");
			Assert.AreSame(osakaNode, result);
		}

		[Test]
		public void 킪}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Tokyo']");
			Func<XmlNode, bool> match = (node) =>
				(node.Name == "city" && node.Attributes["name"].Value == "Osaka");

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			XmlNode osakaNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");
			Assert.AreSame(osakaNode, result);
		}

		[Test]
		public void ]Z킪}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Tokyo']");
			Func<XmlNode, bool> match = (node) =>
				(node.Name == "city" && node.Attributes["name"].Value == "Hong Kong");

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			XmlNode hongKongNode = this.doc.SelectSingleNode(@"/root/country[@name='China']/city[@name='Hong Kong']");
			Assert.AreSame(hongKongNode, result);
		}

		[Test]
		public void Z}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");
			Func<XmlNode, bool> match = (node) =>
				(node.Name == "city" && node.Attributes["name"].Value == "Tokyo");

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			Assert.Null(result);
		}

		[Test]
		public void ZƏ]Z킪}b`()
		{
			// 
			XmlNode currentNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");
			Func<XmlNode, bool> match = (node) =>
				(node.Name == "city" && node.Attributes["name"].Value != "Osaka");

			// s
			XmlNode result = XmlTreeManager.Default.FindNext(currentNode, match, false);

			// 
			XmlNode beijingNode = this.doc.SelectSingleNode(@"/root/country[@name='China']/city[@name='Beijing']");
			Assert.AreSame(beijingNode, result, result.OuterXml);
		}
	}
}
