﻿using System;

using NUnit.Framework;

using SystemNeo.Xml.XPath;

namespace SystemNeoTest.Xml.XPath.XPathUtilTest
{
	[TestFixture]
	public class CreateStringExpression
	{
		[Test]
		public void @null()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression(null);

			// 検証
			Assert.AreEqual(@"''", result);
		}

		[Test]
		public void 文字列以外()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression(123);

			// 検証
			Assert.AreEqual(@"'123'", result);
		}

		[Test]
		public void 空文字列()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression("");

			// 検証
			Assert.AreEqual(@"''", result);
		}

		[Test]
		public void シングルクォートを含まない文字列()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression(@"a""b");

			// 検証
			Assert.AreEqual(@"'a""b'", result);
		}

		[Test]
		public void シングルクォートで始まる文字列()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression("'ab");

			// 検証
			Assert.AreEqual(@"concat('',""'"",'ab')", result);
		}

		[Test]
		public void シングルクォートで終わる文字列()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression("ab'");

			// 検証
			Assert.AreEqual(@"concat('ab',""'"",'')", result);
		}

		[Test]
		public void シングルクォートを途中に含む文字列()
		{
			// 実行
			string result = XPathUtil.CreateStringExpression("a'b");

			// 検証
			Assert.AreEqual(@"concat('a',""'"",'b')", result);
		}
	}
}
