using System;
using SystemNeo.Reflection;
using NUnit.Framework;

namespace SystemNeoTest.Reflection.LateBinderTest
{
	internal class TestUtil
	{
		public readonly string CLASS_NAME = "<LateBinderTest>";

		public string NamespaceName {
			get {
				return "<SystemNeoTest.Reflection>";
			}
		}
	}

	/// <summary>
	/// Eval \bh̃eXg
	/// </summary>
	[TestFixture]
	public class Eval
	{
		[Test]
		public void _CNg_null()
		{
			// 
			var lb = new LateBinder(null);

			// s
			object result = lb.Eval();

			// 
			Assert.IsNull(result);
		}

		[Test]
		public void _CNg()
		{
			// 
			string s = new string('A', 3);
			var lb = new LateBinder(s);

			// s
			object result = lb.Eval();

			// 
			Assert.AreSame(s, result);
		}

		[Test]
		public void Call_p[^Ȃ()
		{
			// 
			var lb = new LateBinder("ABC").Call("ToLower");

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("abc", result);
		}

		[Test]
		public void Call_p[^()
		{
			// 
			var lb = new LateBinder("ABCDEF").Call("Substring", 2, 3);

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("CDE", result);
		}

		[Test][ExpectedException(typeof(MissingMemberException))]
		public void Call_YȂ()
		{
			// 
			var lb = new LateBinder("ABC").Call("toString");

			// s
			lb.Eval();
		}

		[Test]
		public void Get_tB[h()
		{
			// 
			var lb = new LateBinder(new TestUtil()).Get("CLASS_NAME");

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("<LateBinderTest>", result);
		}

		[Test]
		public void Get_vpeB()
		{
			// 
			var lb = new LateBinder(new TestUtil()).Get("NamespaceName");

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("<SystemNeoTest.Reflection>", result);
		}

		[Test][ExpectedException(typeof(MissingMemberException))]
		public void Get_YȂ()
		{
			// 
			var lb = new LateBinder("ABC").Get("ToString");

			// s
			lb.Eval();
		}

		[Test]
		public void Item_tB[h()
		{
			// 
			var lb = new LateBinder(new TestUtil())["CLASS_NAME"];

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("<LateBinderTest>", result);
		}

		[Test]
		public void Item_vpeB()
		{
			// 
			var lb = new LateBinder(new TestUtil())["NamespaceName"];

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("<SystemNeoTest.Reflection>", result);
		}

		[Test]
		public void Item_p[^Ȃ\bh()
		{
			// 
			var lb = new LateBinder("ABC")["ToLower"];

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("abc", result);
		}

		[Test]
		public void Item_p[^胁\bh()
		{
			// 
			var lb = new LateBinder("ABCDEF")["Substring", 2, 3];

			// s
			object result = lb.Eval();

			// 
			Assert.AreEqual("CDE", result);
		}

		[Test][ExpectedException(typeof(MissingMemberException))]
		public void Item_YȂ()
		{
			// 
			var lb = new LateBinder("ABC")["ToLower", 2];

			// s
			lb.Eval();
		}
	}
}
