using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using SystemNeo.Drawing;
using NUnit.Framework;

namespace SystemNeoTest.Drawing.ImageUtilTest
{
	[TestFixture]
	public class TryLoadImage_Stream
	{
		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void @null()
		{
			// s
			Image result = ImageUtil.TryLoadImage(null);
		}

		[Test]
		public void ̃Xg[()
		{
			// 
			Stream stream = new MemoryStream();

			// s
			Image result = ImageUtil.TryLoadImage(stream);

			// 
			Assert.Null(result);
		}

		[Test]
		public void 摜܂܂ꂽXg[()
		{
			// 
			Stream stream = new MemoryStream();
			using (var bitmap = new Bitmap(32, 16)) {
				bitmap.Save(stream, ImageFormat.Png);
			}

			// s
			Image result = ImageUtil.TryLoadImage(stream);

			// 
			Assert.NotNull(result);
			Assert.AreEqual(new Size(32, 16), result.Size);
		}
	}
}
