﻿using System;
using System.ComponentModel;
using System.IO;
using System.Xml;

namespace SystemNeo.Xml
{
	/// <summary>
	/// 
	/// </summary>
	public class XmlElementFormatter : AbstractFormatter
	{
		// public プロパティ //

		[DefaultValue(false)]
		public bool WithContent { get; set; }

		// public コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		public XmlElementFormatter() { }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="withContent"></param>
		public XmlElementFormatter(bool withContent)
		{
			this.WithContent = withContent;
		}

		// protected internal メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			if (value is XmlElement) {
				writer.Write(XmlUtil.ElementToString((XmlElement)value, this.WithContent));
			} else {
				throw new ArgumentException();
			}
		}
	}
}
