using System;
using System.Collections;
using System.ComponentModel;
using System.IO;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class ByteArrayFormatter : CollectionFormatterBase
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultFormatExpression = "X2";

		#region private fields
		private string formatExpression = DefaultFormatExpression;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(DefaultFormatExpression)]
		public string FormatExpression
		{
			get {
				return this.formatExpression;
			}
			set {
				this.formatExpression = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public ByteArrayFormatter() : this(0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="maxCount"></param>
		public ByteArrayFormatter(int maxCount)
		{
			this.Separator = " ";
			this.MaxCount = maxCount;
		}

		// protected internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			if (value is byte[]) {
				this.WriteByteArray(writer, (byte[])value);
			} else {
				throw new ArgumentException();
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="bytes"></param>
		private void WriteByteArray(TextWriter writer, byte[] bytes)
		{
			writer.Write(this.BeginBracket);
			for (int i = 0; i < bytes.Length; i++) {
				if (i > 0) {
					writer.Write(this.Separator);
				}
				if (this.MaxCount > 0 && i > this.MaxCount) {
					writer.Write(this.EllipsisExpression);
					break;
				}
				writer.Write(bytes[i].ToString(this.formatExpression));
			}
			writer.Write(this.EndBracket);
		}
	}
}
