using System;
using System.Collections;
using System.Diagnostics;
using System.Linq;
using System.Reflection;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// ^̃o\܂B
	/// <see cref="System.Reflection.MemberInfo">MemberInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public abstract class MemberInfoNeo
	{
		#region private fields
		private const int CacheQueueLimit = 1024 * 8;
		private static readonly IDictionary cache = new Hashtable();
		private static readonly Queue cacheQueue = new Queue();
		#endregion

		// protected tB[h //

		/// <summary>
		/// 
		/// </summary>
		protected readonly MemberInfo member;

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public abstract MemberAccessibility Accessibility { get; }

		/// <summary>
		/// 
		/// </summary>
		public MemberInfo AsMember
		{
			get {
				return this.member;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeNeo DeclaringType
		{
			get {
				return this.member.DeclaringType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public abstract bool IsAbstract { get; }

		/// <summary>
		/// 
		/// </summary>
		public abstract bool IsFinal { get; }

		/// <summary>
		/// 
		/// </summary>
		public abstract bool IsSpecialName { get; }

		/// <summary>
		/// 
		/// </summary>
		public abstract bool IsStatic { get; }

		/// <summary>
		/// 
		/// </summary>
		public MemberTypes MemberType
		{
			get {
				return this.member.MemberType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string Name
		{
			get {
				return this.member.Name;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeNeo ReflectedType
		{
			get {
				return this.member.ReflectedType;
			}
		}

		// protected RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="member"></param>
		protected MemberInfoNeo(MemberInfo member) : base()
		{
			ArgumentUtil.AssertNull(member, "member");
			this.member = member;
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="members"></param>
		/// <returns></returns>
		public static MemberInfoNeo[] ConvertArray(MemberInfo[] members)
		{
			return members == null ? null : Array.ConvertAll(members, (m) => (MemberInfoNeo)m);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="member"></param>
		/// <returns></returns>
		public static MemberInfoNeo CreateInstance(MemberInfo member)
		{
			if (member is Type) {
				return new TypeNeo((Type)member);
			}
			if (member is ConstructorInfo) {
				return new ConstructorInfoNeo((ConstructorInfo)member);
			}
			if (member is MethodInfo) {
				return new MethodInfoNeo((MethodInfo)member);
			}
			if (member is EventInfo) {
				return new EventInfoNeo((EventInfo)member);
			}
			if (member is PropertyInfo) {
				return new PropertyInfoNeo((PropertyInfo)member);
			}
			if (member is FieldInfo) {
				return new FieldInfoNeo((FieldInfo)member);
			}
			throw new ArgumentException();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool Equals(object obj)
		{
			return obj is MemberInfoNeo && ((MemberInfoNeo)obj).member.Equals(this.member);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public object[] GetCustomAttributes()
		{
			return this.member.GetCustomAttributes(false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="inherit"></param>
		/// <returns></returns>
		public object[] GetCustomAttributes(bool inherit)
		{
			return this.member.GetCustomAttributes(inherit);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributeType"></param>
		/// <param name="inherit"></param>
		/// <returns></returns>
		public object[] GetCustomAttributes(Type attributeType, bool inherit)
		{
			return this.member.GetCustomAttributes(attributeType, inherit);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		public T[] GetCustomAttributes<T>() where T : Attribute
		{
			return GetCustomAttributes<T>(false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="inherit"></param>
		/// <returns></returns>
		public T[] GetCustomAttributes<T>(bool inherit) where T : Attribute
		{
			object[] attributes = this.member.GetCustomAttributes(typeof(T), inherit);
			return Array.ConvertAll(attributes, ObjectUtil.Cast<T>);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode()
		{
			return this.member.GetHashCode();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributeType"></param>
		/// <param name="inherit"></param>
		/// <returns></returns>
		public bool IsDefined(Type attributeType, bool inherit)
		{
			return this.member.IsDefined(attributeType, inherit);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return this.member.ToString();
		}

		// protected static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="member"></param>
		/// <returns></returns>
		protected static MemberInfoNeo GetCachedInstance(MemberInfo member)
		{
			if (member == null) {
				return null;
			}
			MemberInfoNeo result;
			var wr = (WeakReference)cache[member];
			if (wr == null || ! wr.IsAlive) {
				result = CreateInstance(member);
				if (wr == null) {
					wr = new WeakReference(result);
				} else {
					Debug.WriteLine(string.Format(
							"MemberInfoEx.GetCachedInstance(): {0} {1}",
							member.DeclaringType, member.ToString()));
					wr.Target = result;
				}
				cache[member] = wr;
			} else {
				result = (MemberInfoNeo)wr.Target;
			}

			if (cacheQueue.Count >= CacheQueueLimit) {
				cacheQueue.Dequeue();
			}
			cacheQueue.Enqueue(result);
			return result;
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="member"></param>
		/// <returns></returns>
		public static implicit operator MemberInfoNeo(MemberInfo member)
		{
			return GetCachedInstance(member);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="memberEx"></param>
		/// <returns></returns>
		public static explicit operator MemberInfo(MemberInfoNeo member)
		{
			return (member == null ? null : member.member);
		}
	}
}
