using System;
using System.Linq;
using System.Reflection;

using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// Cxg\܂B
	/// <see cref="System.Reflection.EventInfo">EventInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class EventInfoNeo : OverridableMember
	{
		#region private fields
		private readonly MethodInfoNeo addMethod;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public Type EventHandlerType
		{
			get {
				return this.AsEvent.EventHandlerType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsAbstract
		{
			get {
				return this.addMethod.IsAbstract;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsFinal
		{
			get {
				return this.addMethod.IsFinal;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsMulticast
		{
			get {
				return this.AsEvent.IsMulticast;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverriding
		{
			get {
				return this.addMethod.IsOverriding;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsSpecialName
		{
			get {
				return this.AsEvent.IsSpecialName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsStatic
		{
			get {
				return this.addMethod.IsStatic;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsVirtual
		{
			get {
				return this.addMethod.IsVirtual;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override TypeNeo MappedInterface
		{
			get {
				return this.addMethod.MappedInterface;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override MemberAccessibility Accessibility
		{
			get {
				return this.addMethod.Accessibility;
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private EventInfo AsEvent
		{
			get {
				return (EventInfo)this.member;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="eventInfo"></param>
		internal EventInfoNeo(EventInfo eventInfo) : base(eventInfo)
		{
			this.addMethod = eventInfo.GetAddMethod(true);
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="events"></param>
		/// <returns></returns>
		public static EventInfoNeo[] ConvertArray(EventInfo[] events)
		{
			return events == null ? null : Array.ConvertAll(events, (e) => (EventInfoNeo)e);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo GetAddMethod()
		{
			return this.GetAddMethod(false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nonPublic"></param>
		/// <returns></returns>
		public MethodInfoNeo GetAddMethod(bool nonPublic)
		{
			return this.AsEvent.GetAddMethod(nonPublic);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo GetRaiseMethod()
		{
			return this.AsEvent.GetRaiseMethod();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo GetRemoveMethod()
		{
			return this.GetRemoveMethod(false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nonPublic"></param>
		/// <returns></returns>
		public MethodInfoNeo GetRemoveMethod(bool nonPublic)
		{
			return this.AsEvent.GetRemoveMethod(nonPublic);
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="eventInfo"></param>
		/// <returns></returns>
		public static implicit operator EventInfoNeo(EventInfo eventInfo)
		{
			return (EventInfoNeo)GetCachedInstance(eventInfo);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="@event"></param>
		/// <returns></returns>
		public static explicit operator EventInfo(EventInfoNeo @event)
		{
			if (@event == null) {
				return null;
			} else {
				return @event.AsEvent;
			}
		}
	}
}
