using System;
using System.CodeDom.Compiler;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Text.RegularExpressions;

using SystemNeo;
using SystemNeo.IO;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// o񂩂\[XR[h𐶐܂B
	/// </summary>
	public abstract class CodeGeneratorNeo : ICloneable
	{
		#region private static fields
		private const string csharp = "c#";
		private static readonly IDictionary defaultDictionary;
		private static readonly string[] methodParameterBrackets = {"(", ")"};
		private const string namespaceTypeSeparator = ".";
		private const string nestedTypeSeparator = ".";
		private static readonly string[] propertyParameterBrackets = {"[", "]"};
		private const string typeMemberSeparator = ".";
		#endregion

		#region private fields
		private string parameterSeparator = ", ";
		private bool showNamespace = true;
		private bool useTypeNameAliases = true;
		#endregion

		// public vpeB //

		/// <summary>
		/// WFlbN^p[^镶擾܂B
		/// </summary>
		public abstract string[] GenericArgumentBrackets { get; }

		/// <summary>
		/// \bh̃p[^镶擾܂B
		/// </summary>
		public virtual string[] MethodParameterBrackets
		{
			get {
				return methodParameterBrackets;
			}
		}

		/// <summary>
		/// vpeB̃p[^镶擾܂B
		/// </summary>
		public virtual string[] PropertyParameterBrackets
		{
			get {
				return propertyParameterBrackets;
			}
		}

		/// <summary>
		/// OԂƌ^̊ԂȂ擾܂B
		/// </summary>
		public virtual string NamespaceTypeSeparator
		{
			get {
				return namespaceTypeSeparator;
			}
		}

		/// <summary>
		/// qɂȂ^Ƃꂪ^̖OȂ擾܂B
		/// </summary>
		public virtual string NestedTypeSeparator
		{
			get {
				return nestedTypeSeparator;
			}
		}

		/// <summary>
		/// m̊ԂȂ擾܂͐ݒ肵܂B
		/// </summary>
		public virtual string ParameterSeparator
		{
			get {
				return this.parameterSeparator;
			}
			set {
				this.parameterSeparator = value;
			}
		}

		/// <summary>
		/// OԂ܂߂ĕ\邩ǂ擾܂͐ݒ肵܂B
		/// </summary>
		public bool ShowNamespace
		{
			get {
				return this.showNamespace;
			}
			set {
				this.showNamespace = value;
			}
		}

		/// <summary>
		/// ^ƃo[̖OȂ擾܂B
		/// </summary>
		public virtual string TypeMemberSeparator
		{
			get {
				return typeMemberSeparator;
			}
		}

		/// <summary>
		/// ^̃GCAXgpĕ\邩ǂ擾܂͐ݒ肵܂B
		/// </summary>
		public bool UseTypeNameAliases
		{
			get {
				return this.useTypeNameAliases;
			}
			set {
				this.useTypeNameAliases = value;
			}
		}

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static CodeGeneratorNeo()
		{
			defaultDictionary = new Hashtable(StringComparer.CurrentCultureIgnoreCase);
			Initialize(csharp, new CSharpCodeGeneratorNeo());
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="language"></param>
		/// <returns></returns>
		public static CodeGeneratorNeo GetGenerator(string language)
		{
			ArgumentUtil.AssertNull(language, "language");
			var generator = (CodeGeneratorNeo)defaultDictionary[language];
			return (CodeGeneratorNeo)generator.Clone();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public object Clone()
		{
			var clone = (CodeGeneratorNeo)this.MemberwiseClone();
			this.CloneInternal(clone);
			return clone;
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="genericArguments"></param>
		/// <returns></returns>
		public string GetGenericArgumentsAsString(Type[] genericArguments)
		{
			ArgumentUtil.AssertNull(genericArguments, "genericArguments");
			return this.GetGenericArgumentsAsStringInternal(TypeNeo.ConvertArray(genericArguments));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="genericArguments"></param>
		/// <returns></returns>
		public string GetGenericArgumentsAsString(TypeNeo[] genericArguments)
		{
			ArgumentUtil.AssertNull(genericArguments, "genericArguments");
			return this.GetGenericArgumentsAsStringInternal(genericArguments);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		/// <returns></returns>
		public string GetMethodName(MethodBaseNeo method)
		{
			ArgumentUtil.AssertNull(method, "method");
			var sw = new StringWriter();
			TypeNeo @interface = method.MappedInterface;
			if (@interface == null) {
				sw.Write(method.Name);
			} else {
				CodeGeneratorNeo cgx = GetGenerator(csharp);
				cgx.ShowNamespace = true;
				cgx.UseTypeNameAliases = false;
				string interfaceName = cgx.GetTypeName(@interface) + ".";
				if (method.Name.StartsWith(interfaceName)) {
					this.AppendTypeNameInternal(sw, @interface);
					sw.Write(this.TypeMemberSeparator);
					sw.Write(method.Name.Substring(interfaceName.Length));
				} else {
					sw.Write(method.Name);
				}
			}
			if (method is MethodInfoNeo) {
				TypeNeo[] genericArguments = method.GetGenericArguments();
				if (genericArguments.Length > 0) {
					this.AppendGenericArgumentsInternal(sw, genericArguments);
				}
			}
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		/// <param name="name"></param>
		/// <returns></returns>
		public string GetMethodParameters(MethodBaseNeo method, bool name)
		{
			ArgumentUtil.AssertNull(method, "method");
			var @params = method.GetParameters();
			return this.GetParametersInternal(@params, name, this.MethodParameterBrackets);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="property"></param>
		/// <param name="name"></param>
		/// <returns></returns>
		public string GetPropertyParameters(PropertyInfoNeo property, bool name)
		{
			ArgumentUtil.AssertNull(property, "property");
			var @params = property.GetParameters();
			if (@params == null || @params.Length == 0) {
				return string.Empty;
			}
			return this.GetParametersInternal(@params, name, this.PropertyParameterBrackets);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public string GetTypeName(TypeNeo type)
		{
			ArgumentUtil.AssertNull(type, "type");
			var sw = new StringWriter();
			this.AppendTypeNameInternal(sw, type);
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public virtual string GetTypeNameAlias(TypeNeo type)
		{
			return null;
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="elementType"></param>
		/// <param name="rank"></param>
		protected virtual void AppendArrayTypeNameInternal(
				TextWriter writer, TypeNeo elementType, int rank)
		{
			this.AppendTypeNameInternal(writer, elementType);
			writer.Write("[");
			for (int i = 1; i < rank; i++) {
				writer.Write(",");
			}
			writer.Write("]");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="elementType"></param>
		/// <param name="namespace"></param>
		protected virtual void AppendByRefTypeNameInternal(TextWriter writer, TypeNeo elementType)
		{
			this.AppendTypeNameInternal(writer, elementType);
			writer.Write("&");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="param"></param>
		/// <param name="name"></param>
		protected abstract void AppendParameter(TextWriter writer, ParameterInfo param, bool name);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="elementType"></param>
		protected virtual void AppendPointerTypeNameInternal(TextWriter writer, TypeNeo elementType)
		{
			this.AppendTypeNameInternal(writer, elementType);
			writer.Write("*");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="type"></param>
		protected virtual void AppendTypeNameInternal(TextWriter writer, TypeNeo type)
		{
			if (type.IsArray) {
				this.AppendArrayTypeNameInternal(writer, type.ElementType, type.GetArrayRank());
			} else if (type.IsByRef) {
				this.AppendByRefTypeNameInternal(writer, type.ElementType);
			} else if (type.IsPointer) {
				this.AppendPointerTypeNameInternal(writer, type.ElementType);
			} else if (type.IsGenericParameter) {
				writer.Write(type.Name);
			} else {
				if (this.useTypeNameAliases) {
					string alias = this.GetTypeNameAlias(type);
					if (alias != null) {
						writer.Write(alias);
						return;
					}
				}
				this.AppendTypeNameSimple(writer, type);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="clone"></param>
		protected virtual void CloneInternal(CodeGeneratorNeo clone) {}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="language"></param>
		/// <param name="generator"></param>
		private static void Initialize(string language, CodeGeneratorNeo generator)
		{
			var languages = new List<string>() {language};
			CompilerInfo compiler = CodeDomProvider.GetCompilerInfo(language);
			if (compiler == null) {
				return;
			}
			languages.AddRange(compiler.GetLanguages());
			foreach (string lang in languages) {
				defaultDictionary[lang] = generator;
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="genericArguments"></param>
		private void AppendGenericArgumentsInternal(TextWriter writer, TypeNeo[] genericArguments)
		{
			IFormatter typeNameFormatter
					= FormatterFactory.Get<TypeNeo>(this.AppendTypeNameInternal);
			var formatter = new Formatter();
			formatter.CollectionFormatter.BeginBracket = this.GenericArgumentBrackets[0];
			formatter.CollectionFormatter.EndBracket   = this.GenericArgumentBrackets[1];
			formatter.CollectionFormatter.Separator = this.parameterSeparator;
			formatter.CustomFormatters.Add(typeNameFormatter);
			formatter.WriteTo(writer, genericArguments);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="type"></param>
		private void AppendTypeNameSimple(TextWriter writer, TypeNeo type)
		{
			if (type.DeclaringType == null) {
				if (this.showNamespace && type.Namespace != null && type.Namespace.Length > 0) {
					writer.Write(type.Namespace);
					writer.Write(this.NamespaceTypeSeparator);
				}
			} else {
				this.AppendTypeNameInternal(writer, type.DeclaringType);
				writer.Write(this.NestedTypeSeparator);
			}
			if (type.IsGenericType || type.IsGenericTypeDefinition) {
				string name = Regex.Replace(type.Name, @"`\d+$", string.Empty);
				writer.Write(name);
				this.AppendGenericArgumentsInternal(writer, type.GetGenericArguments());
			} else {
				writer.Write(type.Name);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="genericArguments"></param>
		/// <returns></returns>
		private string GetGenericArgumentsAsStringInternal(TypeNeo[] genericArguments)
		{
			if (genericArguments.Length == 0) {
				return string.Empty;
			}
			var sw = new StringWriter();
			this.AppendGenericArgumentsInternal(sw, genericArguments);
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="params"></param>
		/// <param name="name"></param>
		/// <param name="brackets"></param>
		/// <returns></returns>
		private string GetParametersInternal(ParameterInfo[] @params, bool name, string[] brackets)
		{
			var sw = new StringWriter();
			sw.Write(brackets[0]);
			for (int i = 0; i < @params.Length; i++) {
				if (i > 0) {
					sw.Write(this.ParameterSeparator);
				}
				this.AppendParameter(sw, @params[i], name);
			}
			sw.Write(brackets[1]);
			return sw.ToString();
		}
	}
}
