﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;

using SystemNeo.Collections;
using SystemNeo.Text;

namespace SystemNeo.Net
{
	/// <summary>
	/// 
	/// </summary>
	public class UriUtil
	{
		public static Uri CreateUri(string uriString, IDictionary<string, string> queryString, Encoding encoding)
		{
			ArgumentUtil.AssertNull(queryString, "queryString");
			return CreateUri(uriString, DictionaryUtil.ToNameValueCollection(queryString), encoding);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="uriString"></param>
		/// <param name="queryString"></param>
		/// <param name="encoding"></param>
		/// <returns></returns>
		public static Uri CreateUri(string uriString, NameValueCollection queryString, Encoding encoding)
		{
			ArgumentUtil.AssertNull(uriString, "uriString");
			ArgumentUtil.AssertNull(queryString, "queryString");
			ArgumentUtil.AssertNull(encoding, "encoding");
			var query = from string name in queryString
			            from value in queryString.GetValues(name)
			            select HttpUtility.UrlEncode(name, encoding)
						         + "=" + HttpUtility.UrlEncode(value, encoding);
			return new Uri(uriString + "?" + string.Join("&", query));
		}
	}
}
