using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo
{
	/// <summary>
	/// IuWFNg𕶎ɕϊ܂B
	/// </summary>
	public class Formatter : AbstractFormatter
	{
		#region private fields
		private readonly ICollection<IFormatter> customFormatters = new List<IFormatter>();
		private string nullExpression = string.Empty;
		private StringFormatter stringFormatter = StringFormatter.Default;
		private readonly ByteArrayFormatter byteArrayFormatter = new ByteArrayFormatter();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public ByteArrayFormatter ByteArrayFormatter
		{
			get {
				return this.byteArrayFormatter;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public CollectionFormatter CollectionFormatter { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public ICollection<IFormatter> CustomFormatters
		{
			get {
				return this.customFormatters;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public DictionaryFormatter DictionaryFormatter { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string FormatExpression { get; set; }

		/// <summary>
		/// null lϊʂƂėp镶擾܂͐ݒ肵܂B
		/// </summary>
		public string NullExpression
		{
			get {
				return this.nullExpression;
			}
			set {
				this.nullExpression = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public StringFormatter StringFormatter
		{
			get {
				return this.stringFormatter;
			}
			set {
				this.stringFormatter = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public Formatter()
		{
			this.CollectionFormatter = new CollectionFormatter(this);
			this.DictionaryFormatter = new DictionaryFormatter(this);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="customFormatters"></param>
		public Formatter(params IFormatter[] customFormatters) : this()
		{
			foreach (var formatter in customFormatters) {
				this.customFormatters.Add(formatter);
			}
		}

		// protected internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			foreach (var formatter in this.GetFormatters()) {
				try {
					formatter.WriteTo(writer, value);
					return;
				} catch (Exception) {
				}
			}
			throw new NotSupportedException();
		}

		// internal static \bh //

		/// <summary>
		/// w肳ꂽ\bhpăIuWFNg𕶎ɕϊA
		/// C^ɏނ߂̃\bh擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="formatter"></param>
		/// <returns></returns>
		internal static TextWriteAction<T> CreateWriteAction<T>(Formatter<T> formatter)
		{
			ArgumentUtil.AssertNull(formatter, "formatter");
			return (writer, value) => writer.Write(formatter(value));
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private ICollection<IFormatter> GetFormatters()
		{
			return new List<IFormatter>(this.customFormatters) {
				new NullFormatter(this.nullExpression),
				this.stringFormatter,
				this.byteArrayFormatter,
				this.DictionaryFormatter,
				this.CollectionFormatter,
				new FormatExpressionFormatter(this.FormatExpression),
				SimpleFormatter.Default
			};
		}
	}
}
