using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;

using SystemNeo;
using SystemNeo.Cache;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// t@Cǂݍ񂾃C[WLbV܂B
	/// </summary>
	public class ImageCache : Cache<string, ImageCacheEntry>
	{
		/// <summary>
		/// 
		/// </summary>
		public static readonly TimeSpan TheLifeTime
				= DateTimeUtil.GetTimeSpan(2, TimeUnit.Minute);

		/// <summary>
		/// 
		/// </summary>
		public static readonly TimeSpan TheCleanInterval
				= DateTimeUtil.GetTimeSpan(30, TimeUnit.Second);

		#region private fields
		private string logFileName;
		private TextWriter logFileWriter;
		#endregion

		// public vpeB //

		/// <summary>
		/// ǂݍ܂ꂽ Dispose ĂȂ摜̐\܂B
		/// </summary>
		public int LoadedImageCount { get; internal set; }

		/// <summary>
		/// Ot@CłB
		/// </summary>
		public string LogFileName
		{
			get {
				return this.logFileName;
			}
			set {
				if (value != this.logFileName) {
					if (this.logFileWriter != null) {
						this.logFileWriter.Close();
						this.logFileWriter = null;
					}
					this.logFileName = value;
					if (value != null && value != "") {
						this.logFileWriter = new StreamWriter(value, true, Encoding.Default);
					}
				}
			}
		}

		/// <summary>
		/// LbVĂ摜̍vTCY擾܂BPʂ̓oCgłB
		/// </summary>
		public long TotalFileSize
		{
			get {
				long size = 0;
				lock (this.dic) {
					foreach (var pair in this.dic) {
						size += pair.Value.FileSize;
					}
				}
				return size;
			}
		}

		// public RXgN^ //

		/// <summary>
		///
		/// </summary>
		public ImageCache() : this(TheLifeTime, TheCleanInterval) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lifeTime"></param>
		/// <param name="cleanInterval"></param>
		public ImageCache(TimeSpan lifeTime, TimeSpan cleanInterval) : base(lifeTime, cleanInterval)
		{
			this.Exception += this.OnException;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="fileName"></param>
		/// <returns></returns>
		public new Image Get(string fileName)
		{
			return this.Get(fileName, null);
		}

		/// <summary>
		///
		/// </summary>
		/// <param name="fileName"></param>
		/// <param name="invocation"></param>
		/// <returns></returns>
		public new Image Get(string fileName, DelegateInvocation invocation)
		{
			if (File.Exists(fileName)) {
				ICacheEntry<string, ImageCacheEntry> entry = base.Get(fileName, invocation);
				return (entry == null ? null : ((ImageCacheEntry)entry).Image);
			} else {
				return null;
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cache"></param>
		/// <param name="key"></param>
		/// <param name="prepared"></param>
		/// <returns></returns>
		protected override ImageCacheEntry CreateEntry(
				ICache<string, ImageCacheEntry> cache, string key,
				CacheEntryEventHandler<string, ImageCacheEntry> prepared)
		{
			return new ImageCacheEntry((ImageCache)cache, key, prepared);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnException(object sender, CacheExceptionEventArgs<string, ImageCacheEntry> e)
		{
			Debug.WriteLine(e.Exception.ToString());
		}
	}
}
