using System;
using System.Collections;
using System.Collections.Generic;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// 1̃L[ɕ̒lRNV\܂B
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TValue"></typeparam>
	public class MultipleDictionary<TKey, TValue>
			: DictionaryNeo<TKey, ICollection<TValue>>, IMultipleDictionary<TKey, TValue>
	{
		#region private fields
		private readonly Func<IList<TValue>> listGenerator;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public new ICollection<TKey> Keys
		{
			get {
				return base.Keys;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public new ICollection<ICollection<TValue>> Values
		{
			get {
				return base.Values;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public MultipleDictionary() : this(null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listGenerator"></param>
		public MultipleDictionary(Func<IList<TValue>> listGenerator) : base()
		{
			this.listGenerator = listGenerator ?? CollectionUtil.CreateGenericList<TValue>;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		public void Add(TKey key, TValue value)
		{
			ArgumentUtil.AssertNull(key, "key");
			if (! this.ContainsKey(key)) {
				base.Add(key, this.listGenerator());
			}
			this.GetItemList(key).Add(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Remove(TKey key, TValue value)
		{
			IList<TValue> list = this.GetItemList(key);
			return list == null ? false : list.Remove(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="values"></param>
		/// <returns></returns>
		public bool TryGetValues(TKey key, out ICollection<TValue> values)
		{
			return base.TryGetValue(key, out values);
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		protected override bool IsAllowedValue(ICollection<TValue> value)
		{
			return value is IList<TValue>;
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		private IList<TValue> GetItemList(TKey key)
		{
			return (IList<TValue>)base[key];
		}
	}
}
