﻿using System;
using System.Collections.Generic;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	public class CounterDictionary<TKey> : FactoryDictionary<TKey, int>
	{
		// public コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		public CounterDictionary() : base((key) => 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		public CounterDictionary(int capacity) : base(capacity, (key) => 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="comparer"></param>
		public CounterDictionary(IEqualityComparer<TKey> comparer) : base(comparer, (key) => 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		/// <param name="comparer"></param>
		public CounterDictionary(int capacity, IEqualityComparer<TKey> comparer)
				: base(capacity, comparer, (key) => 0) {}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public int Increment(TKey key)
		{
			return ++this[key];
		}
	}
}
