﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TValue"></typeparam>
	public abstract class AbstractDictionary<TKey, TValue> : IDictionary<TKey, TValue>
	{
		#region private fields
		private readonly bool readOnly;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public TValue this[TKey key]
		{
			get {
				return this.Get(key);
			}
			set {
				this.Set(key, value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public abstract int Count { get; }

		/// <summary>
		/// 
		/// </summary>
		public virtual bool IsReadOnly
		{
			get {
				return this.readOnly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public ICollection<TKey> Keys
		{
			get {
				return this.GetKeys();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public ICollection<TValue> Values
		{
			get {
				return this.GetValues();
			}
		}

		// protected コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="readOnly"></param>
		protected AbstractDictionary(bool readOnly)
		{
			this.readOnly = readOnly;
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		public virtual void Add(TKey key, TValue value)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		public virtual void Clear()
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public virtual bool ContainsKey(TKey key)
		{
			Func<ICollection<TKey>> getKeys = this.GetKeys;
			Type type = ((Delegate)getKeys).Method.DeclaringType;
			if (type == typeof(AbstractDictionary<TKey, TValue>)) {
				// GetKeys がオーバーライドされていない場合は GetEnumeratorInternal を使う
				return this.GetEnumeratorInternal().Any(pair => this.EqualKeys(pair.Key, key));
			} else {
				// GetKeys がオーバーライドされている場合は GetKeys を使う
				return getKeys().Contains(key);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public virtual bool Remove(TKey key)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool TryGetValue(TKey key, out TValue value)
		{
			try {
				value = this.Get(key);
				return true;
			} catch (KeyNotFoundException) {
				value = default(TValue);
				return false;
			}
		}

		// protected メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key1"></param>
		/// <param name="key2"></param>
		/// <returns></returns>
		protected virtual bool EqualKeys(TKey key1, TKey key2)
		{
			return object.Equals(key1, key2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		protected abstract TValue Get(TKey key);

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected abstract IEnumerable<KeyValuePair<TKey, TValue>> GetEnumeratorInternal();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected virtual ICollection<TKey> GetKeys()
		{
			return this.GetEnumeratorInternal()
					.Select<KeyValuePair<TKey, TValue>, TKey>(DictionaryUtil.GetKey)
					.ToList();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected virtual ICollection<TValue> GetValues()
		{
			return this.GetEnumeratorInternal()
					.Select<KeyValuePair<TKey, TValue>, TValue>(DictionaryUtil.GetValue)
					.ToList();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		protected virtual void Set(TKey key, TValue value)
		{
			throw new NotSupportedException();
		}

		// private メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="item"></param>
		void ICollection<KeyValuePair<TKey, TValue>>.Add(KeyValuePair<TKey, TValue> item)
		{
			this.Add(item.Key, item.Value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="item"></param>
		/// <returns></returns>
		bool ICollection<KeyValuePair<TKey, TValue>>.Contains(KeyValuePair<TKey, TValue> item)
		{
			return this.GetEnumeratorInternal().Any(pair =>
					this.EqualKeys(pair.Key, item.Key) && object.Equals(pair.Value, item.Value));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="array"></param>
		/// <param name="arrayIndex"></param>
		void ICollection<KeyValuePair<TKey, TValue>>.CopyTo(
				KeyValuePair<TKey, TValue>[] array, int arrayIndex)
		{
			var e = this.GetEnumeratorInternal();
			CollectionUtil.Copy(e, 0, array, arrayIndex, e.Count());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="item"></param>
		/// <returns></returns>
		bool ICollection<KeyValuePair<TKey, TValue>>.Remove(KeyValuePair<TKey, TValue> item)
		{
			foreach (var pair in this.GetEnumeratorInternal()) {
				if (object.Equals(pair.Key, item.Key)) {
					if (object.Equals(pair.Value, item.Value)) {
						this.Remove(item.Key);
						return true;
					} else {
						return false;
					}
				}
			}
			return false;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator<KeyValuePair<TKey, TValue>>
				IEnumerable<KeyValuePair<TKey, TValue>>.GetEnumerator()
		{
			return this.GetEnumeratorInternal().GetEnumerator();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetEnumeratorInternal().GetEnumerator();
		}
	}
}
