using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

using SystemNeo;
using SystemNeo.Collections.Generic;
using SystemNeo.Predicates;
using SystemNeo.Text;

namespace SystemNeo.Collections
{
	/// <summary>
	/// RNVɊւ郁\bh񋟂܂B
	/// </summary>
	public static class CollectionUtil
	{
		// public static \bh //

		/// <summary>
		/// V[PX̊evfϊ܂B
		/// </summary>
		/// <typeparam name="TInput"></typeparam>
		/// <typeparam name="TOutput"></typeparam>
		/// <param name="source"></param>
		/// <param name="selector"></param>
		/// <returns></returns>
		public static IEnumerable<TOutput> CastSelect<TInput, TOutput>(
				this IEnumerable source, Func<TInput, TOutput> selector)
		{
			ArgumentUtil.AssertNull(source, "source");
			ArgumentUtil.AssertNull(selector, "selector");
			return source.Cast<TInput>().Select(selector);
		}

		/// <summary>
		/// ̃RNVAĕԂ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="sources"></param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IEnumerable<T> Concat<T>(params IEnumerable[] sources)
		{
			ArgumentUtil.AssertNull(sources, "sources");
			foreach (IEnumerable e in sources) {
				foreach (T obj in e) {
					yield return obj;
				}
			}
		}

		/// <summary>
		/// ̃RNVAĕԂ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="sources"></param>
		/// <returns></returns>
		public static IEnumerable<T> Concat<T>(params IEnumerable<T>[] sources)
		{
			ArgumentUtil.AssertNull(sources, "sources");
			foreach (IEnumerable<T> e in sources) {
				foreach (T obj in e) {
					yield return obj;
				}
			}
		}

		/// <summary>
		/// w肳ꂽRNV̑SĂ̗vfAw肳ꂽXgɒǉ܂B
		/// </summary>
		/// <param name="source"></param>
		/// <param name="destination"></param>
		/// <returns></returns>
		public static int Copy(IEnumerable source, IList destination)
		{
			ArgumentUtil.AssertNull(source, "source");
			ArgumentUtil.AssertNull(destination, "destination");
			int length = Math.Min(source.Cast<object>().Count(), destination.Count);
			CopyInternal(source, 0, destination, null, 0, length);
			return length;
		}

		/// <summary>
		/// w肳ꂽRNV̐擪w肳ꂽʒu܂ł̗vfA
		/// w肳ꂽXgɒǉ܂B
		/// </summary>
		/// <param name="source"></param>
		/// <param name="destination"></param>
		/// <param name="length"></param>
		public static void Copy(IEnumerable source, IList destination, int length)
		{
			Copy(source, 0, destination, 0, length);
		}

		/// <summary>
		/// RNV̗vfXgɃRs[܂B
		/// </summary>
		/// <param name="source"></param>
		/// <param name="sourceIndex"></param>
		/// <param name="destination"></param>
		/// <param name="destinationIndex"></param>
		/// <param name="length"></param>
		public static void Copy(IEnumerable source,
				int sourceIndex, IList destination, int destinationIndex, int length)
		{
			ArgumentUtil.AssertNull(source, "source");
			ArgumentUtil.AssertNull(destination, "destination");
			if (length < 0) {
				throw new ArgumentOutOfRangeException("length");
			}
			CopyInternal(source, sourceIndex, destination, null, destinationIndex, length);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TSource"></typeparam>
		/// <param name="source"></param>
		/// <param name="keySelector"></param>
		/// <returns></returns>
		public static IDictionary<TKey, int> CountBy<TKey, TSource>(
				this IEnumerable<TSource> source, Func<TSource, TKey> keySelector)
		{
			ArgumentUtil.AssertNull(source, "source");
			ArgumentUtil.AssertNull(keySelector, "keySelector");
			var dictionary = new FactoryDictionary<TKey, int>(key => 0);
			foreach (TSource obj in source) {
				TKey key = keySelector(obj);
				dictionary[key]++;
			}
			return dictionary;
		}

		/// <summary>
		/// z쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="length"></param>
		/// <param name="generator"></param>
		/// <returns></returns>
		public static T[] CreateArray<T>(int length, Func<int, T> generator)
		{
			if (length < 0) {
				throw new ArgumentOutOfRangeException("length");
			}
			ArgumentUtil.AssertNull(generator, "generator");
			T[] result = new T[length];
			for (int i = 0; i < length; i++) {
				result[i] = generator(i);
			}
			return result;
		}

		/// <summary>
		/// ̃WFlbN Xg쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		public static IList<T> CreateGenericList<T>()
		{
			return new List<T>();
		}

		/// <summary>
		/// ̃Xg쐬܂B
		/// </summary>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IList CreateList()
		{
			return new ArrayList();
		}

		/// <summary>
		/// ̃Xg쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IList CreateList<T>()
		{
			return new List<T>();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TValue"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="nodeValues"></param>
		/// <param name="hasAsParent"></param>
		/// <param name="createNode"></param>
		/// <param name="addChild"></param>
		/// <param name="nodeValueGetter"></param>
		/// <returns></returns>
		public static TNode[] CreateTree<TValue, TNode>(TValue[] nodeValues,
				HasAsParentDelegate<TValue> hasAsParent, Func<TValue, TNode> createNode,
				Action<TNode, TNode> addChild, Func<TNode, TValue> nodeValueGetter)
		{
			ArgumentUtil.AssertNull(nodeValues, "nodeValues");
			ArgumentUtil.AssertNull(hasAsParent, "hasAsParent");
			ArgumentUtil.AssertNull(createNode, "createNode");
			ArgumentUtil.AssertNull(addChild, "addChild");
			ArgumentUtil.AssertNull(nodeValueGetter, "nodeValueGetter");

			var dic = new Dictionary<TValue, object>();
			var rootList = new List<TNode>();

			for (int i = 0; i < nodeValues.Length; i++) {
				for (int j = 0; j < nodeValues.Length; j++) {
					if (i != j && hasAsParent(nodeValues[i], nodeValues[j])) {
						Queue<TValue> parentQueue;
						try {
							parentQueue = (Queue<TValue>)dic[nodeValues[i]];
						} catch (KeyNotFoundException) {
							parentQueue = new Queue<TValue>();
							dic.Add(nodeValues[i], parentQueue);
						}
						parentQueue.Enqueue(nodeValues[j]);
					}
				}
			}

			// êȂf[^𒊏o
			foreach (TValue node in nodeValues) {
				if (! dic.ContainsKey(node)) {
					TNode treeNode = createNode(node);
					rootList.Add(treeNode);
				}
			}
			TNode[] result = Enumerable.ToArray(rootList.Cast<TNode>());

			// ě₪̂ɂāAu߂veI
			foreach (var pair in dic) {
				var parentQueue = (Queue<TValue>)pair.Value;
				while (parentQueue.Count >= 2) {
					TValue value1 = parentQueue.Dequeue();
					TValue value2 = parentQueue.Dequeue();
					TValue parentValue = (hasAsParent(value1, value2) ? value1 : value2);
					parentQueue.Enqueue(parentValue);
				}
			}

			foreach (TNode node in result) {
				dic.Add(nodeValueGetter(node), node);
			}
			var dicTmp = new Dictionary<TValue, TNode>();
			int leftCount;
			do {
				dicTmp.Clear();
				leftCount = 0;
				foreach (TValue value in dic.Keys) {
					if (dic[value] is Queue<TValue>) {
						var parentQueue = (Queue<TValue>)dic[value];
						Debug.Assert(parentQueue.Count == 1);
						TValue parentData = parentQueue.Peek();
						if (dic[parentData] is TNode) {
							// ẽm[hɍĂAq̃m[h
							TNode childNode = createNode(value);
							TNode parentNode = (TNode)dic[parentData];
							addChild(parentNode, childNode);
							dicTmp.Add(value, childNode);
						} else {
							Debug.Assert(dic[parentData] is Queue<TValue>);
							leftCount++;
						}
					} else {
						Debug.Assert(dic[value] is TNode);
					}
				}
				foreach (var pair in dicTmp) {
					dic[pair.Key] = dicTmp[pair.Key];
				}
			} while (leftCount > 0);

			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TSource"></typeparam>
		/// <typeparam name="TKey"></typeparam>
		/// <param name="e"></param>
		/// <param name="keySelector"></param>
		/// <returns></returns>
		public static IEnumerable<TSource> DistinctBy<TSource, TKey>(
				this IEnumerable<TSource> e, Func<TSource, TKey> keySelector)
		{
			return Enumerable.Distinct(e, new KeyEqualityComparer<TSource, TKey>(keySelector));
		}

		/// <summary>
		/// w肳ꂽRNV̓vfm̑g񋓂܂B
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IEnumerable FindSame(this IEnumerable e)
		{
			return FindSame(e, null, null);
		}

		/// <summary>
		/// w肳ꂽRNV̓vfm̑g񋓂܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name="hashFunction">RNV̗vfɑ΂nbV֐B</param>
		/// <param name="comparison">RNV̗vfmǂ𔻒f郁\bhB</param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IEnumerable FindSame(
				this IEnumerable e, Func<object, int> hashFunction, EqualityComparison comparison)
		{
			ArgumentUtil.AssertNull(e, "e");
			hashFunction = hashFunction ?? ObjectUtil.GetHashCode;
			comparison = comparison ?? object.Equals;
			return FindSameInternal(e.Cast<object>(), hashFunction, (x, y) => comparison(x, y));
		}

		/// <summary>
		/// w肳ꂽRNV̓vfm̑g񋓂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public static IEnumerable<IEnumerable<T>> FindSame<T>(this IEnumerable<T> e)
		{
			return FindSame<T>(e, null);
		}

		/// <summary>
		/// w肳ꂽRNV̓vfm̑g񋓂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="comparer"></param>
		/// <returns></returns>
		public static IEnumerable<IEnumerable<T>> FindSame<T>(
				this IEnumerable<T> e, IEqualityComparer<T> comparer)
		{
			ArgumentUtil.AssertNull(e, "e");
			comparer = comparer ?? EqualityComparer<T>.Default;
			Func<T, int> hashFunction = (obj) => comparer.GetHashCode((T)obj);
			EqualityComparison<T> comparison = comparer.Equals;
			return FindSameInternal(e, hashFunction, comparison);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		public static IEnumerable Flatten(this IEnumerable e)
		{
			ArgumentUtil.AssertNull(e, "e");
			foreach (object obj1 in e) {
				if (IsEnumerationNeeded(obj1)) {
					foreach (object obj2 in Flatten((IEnumerable)obj1)) {
						yield return obj2;
					}
				} else {
					yield return obj1;
				}
			}
		}

		/// <summary>
		/// w肳ꂽRNV̑SĂ̗vfɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="action"></param>
		public static void ForEach<T>(this IEnumerable e, Action<T> action)
		{
			ArgumentUtil.AssertNull(e, "e");
			if (action != null) {
				foreach (T obj in e) {
					action(obj);
				}
			}
		}

		/// <summary>
		/// w肳ꂽvf̂P̗vf擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="current"></param>
		/// <returns></returns>
		public static T GetNextItem<T>(this IEnumerable e, T current)
		{
			ArgumentUtil.AssertNull(e, "e");
			bool found = false;
			foreach (T obj in e) {
				if (object.Equals(obj, current)) {
					found = true;
				} else if (found) {
					return obj;
				}
			}
			return default(T);
		}

		/// <summary>
		/// w肳ꂽvf̂PO̗vf擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="current"></param>
		/// <param name="comparer"></param>
		/// <returns></returns>
		public static T GetPreviousItem<T>(this IEnumerable e, T current)
		{
			ArgumentUtil.AssertNull(e, "e");
			T prev = default(T);
			foreach (T obj in e) {
				if (object.Equals(obj, current)) {
					return prev;
				}
				prev = obj;
			}
			return default(T);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="collection"></param>
		/// <returns></returns>
		public static object GetSyncRoot(ICollection collection)
		{
			ArgumentUtil.AssertNull(collection, "collection");
			return collection.SyncRoot;
		}

		/// <summary>
		/// w肳ꂽRNV̂w肳ꂽlɓŏ̗vf̃CfbNX擾܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public static int IndexOf(this IEnumerable e, object value)
		{
			ArgumentUtil.AssertNull(e, "e");
			int index = 0;
			foreach (object obj in e) {
				if (object.Equals(obj, value)) {
					return index;
				}
				index++;
			}
			return -1;
		}

		/// <summary>
		/// RNV̊evfAĒP̕쐬܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name="separator"></param>
		/// <returns></returns>
		public static string Join(this IEnumerable e, string separator)
		{
			return new CollectionFormatter(null, null, separator).ToString(e);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ő̂̂擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="values"></param>
		/// <returns></returns>
		public static T Max<T>(IEnumerable<T> e) where T : IComparable
		{
			return Select<T>(e, ObjectUtil.GetGreater);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ő̂̂擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="comparison"></param>
		/// <returns></returns>
		public static T Max<T>(this IEnumerable e, Comparison<T> comparison)
		{
			return MaxMinInternal<T, T>(e, null, comparison, SelectGreater);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ő̂̂擾܂B
		/// </summary>
		/// <typeparam name="TElement"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="e"></param>
		/// <param name="valueGetter"></param>
		/// <returns></returns>
		public static TElement Max<TElement, TValue>(
				this IEnumerable e, Func<TElement, TValue> valueGetter) where TValue : IComparable
		{
			var comparison = DelegateUtil.CreateComparison<TValue>();
			return MaxMinInternal(e, valueGetter, comparison, SelectGreater);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ő̂̂擾܂B
		/// </summary>
		/// <typeparam name="TElement"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="e"></param>
		/// <param name="valueGetter"></param>
		/// <param name="comparison"></param>
		/// <returns></returns>
		public static TElement Max<TElement, TValue>(this IEnumerable e,
				Func<TElement, TValue> valueGetter, Comparison<TValue> comparison)
		{
			return MaxMinInternal(e, valueGetter, comparison, SelectGreater);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ŏ̂̂擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="values"></param>
		/// <returns></returns>
		public static T Min<T>(IEnumerable<T> e) where T : IComparable
		{
			return Select<T>(e, ObjectUtil.GetLess);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ŏ̂̂擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="comparison"></param>
		/// <returns></returns>
		public static T Min<T>(this IEnumerable e, Comparison<T> comparison)
		{
			return MaxMinInternal<T, T>(e, null, comparison, SelectLess);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ŏ̂̂擾܂B
		/// </summary>
		/// <typeparam name="TElement"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="e"></param>
		/// <param name="valueGetter"></param>
		/// <returns></returns>
		public static TElement Min<TElement, TValue>(
				this IEnumerable e, Func<TElement, TValue> valueGetter) where TValue : IComparable
		{
			var comparison = DelegateUtil.CreateComparison<TValue>();
			return MaxMinInternal(e, valueGetter, comparison, SelectLess);
		}

		/// <summary>
		/// w肳ꂽRNV̗vf̂ŏ̂̂擾܂B
		/// </summary>
		/// <typeparam name="TElement"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="e"></param>
		/// <param name="valueGetter"></param>
		/// <param name="comparison"></param>
		/// <returns></returns>
		public static TElement Min<TElement, TValue>(this IEnumerable e,
				Func<TElement, TValue> valueGetter, Comparison<TValue> comparison)
		{
			return MaxMinInternal(e, valueGetter, comparison, SelectLess);
		}

		/// <summary>
		/// w肳ꂽRNV̗vfבւĊi[zԂ܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name="comparer"></param>
		/// <returns></returns>
		public static object[] OrderBy(this IEnumerable e, IComparer comparer)
		{
			object[] array = Enumerable.ToArray(e.Cast<object>());
			Array.Sort(array, comparer ?? Comparer.Default);
			return array;
		}

		/// <summary>
		/// w肳ꂽRNV̗vfבւĊi[zԂ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="comparer"></param>
		/// <returns></returns>
		public static T[] OrderBy<T>(this IEnumerable e, IComparer<T> comparer)
		{
			T[] array = Enumerable.ToArray(e.Cast<T>());
			Array.Sort(array, comparer ?? Comparer<T>.Default);
			return array;
		}

		/// <summary>
		/// w肳ꂽRNV̗vfבւĊi[zԂ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public static T[] OrderBy<T>(this IEnumerable<T> e)
		{
			return OrderBy(e, (IComparer<T>)null);
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oĐVXg쐬܂B
		/// </summary>
		/// <param name="list"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IList PickUp(this IList list, object value)
		{
			return PickUp(list, value, null);
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oĐVXg쐬܂B
		/// </summary>
		/// <param name="list">vf𔲂oXgB</param>
		/// <param name="value">Xg甲olB</param>
		/// <param name="comparison">vf̒lrۂɗp EqualityComparisonB</param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static IList PickUp(this IList list, object value, EqualityComparison comparison)
		{
			ArgumentUtil.AssertNull(list, "list");
			if (list.IsFixedSize) {
				throw new ArgumentException("Xg͉ςłȂ΂Ȃ܂B", "list");
			}
			comparison = comparison ?? object.Equals;
			IList result = PickUpInternal(list, value, comparison, CreateList);
			return result ?? CreateList();
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oĐVXg쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="list"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public static IList<T> PickUp<T>(this IList<T> list, T value)
		{
			return PickUp(list, value, null);
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oĐVXg쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="list">vf𔲂oXgB</param>
		/// <param name="value">Xg甲olB</param>
		/// <param name="comparison">vf̒lrۂɗp EqualityComparisonB</param>
		/// <returns></returns>
		public static IList<T> PickUp<T>(
				this IList<T> list, T value, EqualityComparison<T> comparison)
		{
			ArgumentUtil.AssertNull(list, "list");
			if (list.IsReadOnly) {
				throw new ArgumentException("Xg͉ςłȂ΂Ȃ܂B", "list");
			}
			comparison = comparison ?? ObjectUtil.Equals;
			IList<T> result = PickUpInternal<T>(list, value, comparison, CreateGenericList<T>);
			return result ?? CreateGenericList<T>();
		}

		/// <summary>
		/// w肳ꂽRNVAw肳ꂽɏ]Ēl1o܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="selector">RNV̗vfmrĒlo\bhB</param>
		/// <returns></returns>
		public static T Select<T>(this IEnumerable e, Selector<T> selector)
		{
			ArgumentUtil.AssertNull(e, "e");
			ArgumentUtil.AssertNull(selector, "selector");
			T result = default(T);
			int i = 0;
			foreach (T obj in e) {
				if (i++ == 0) {
					result = obj;
				} else {
					result = selector(result, obj);
				}
			}
			if (i == 0) {
				throw new ArgumentException("RNVłB", "e");
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public static IList<T> Shuffle<T>(this IEnumerable<T> e)
		{
			var random = new Random();
			var list = new List<T>();
			foreach (T t in e) {
				int index = random.Next(list.Count + 1);
				list.Insert(index, t);
			}
			return list;
		}

		/// <summary>
		/// w肳ꂽRNVƓvf̕т1̔z쐬܂B
		/// </summary>
		/// <param name="source"></param>
		/// <param name="elementType">쐬z̗vf̌^B</param>
		/// <returns></returns>
		[Obsolete("WFlbNȃRNVgpĂB")]
		public static Array ToArray(this IEnumerable source, Type elementType)
		{
			ArgumentUtil.AssertNull(source, "source");
			elementType = elementType ?? typeof(object);
			int count = source.Cast<object>().Count();
			Array result = Array.CreateInstance(elementType, count);
			CopyInternal(source, 0, result, elementType, 0, count);
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="provider"></param>
		/// <returns></returns>
		public static IEnumerable<T> Where<T>(this IEnumerable e, IPredicateProvider<T> provider)
		{
			return e.Cast<T>().Where(provider.Func);
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="sourceIndex"></param>
		/// <param name="destination"></param>
		/// <param name="destinationType"></param>
		/// <param name="destinationIndex"></param>
		/// <param name="length"></param>
		internal static void CopyInternal(IEnumerable source, int sourceIndex,
				IList destination, Type destinationType, int destinationIndex, int length)
		{
			if (length == 0) {
				return;
			}
			var e = source.GetEnumerator();
			for (int i = 0; i < sourceIndex; i++) {
				e.MoveNext();
			}
			for (int i = 0; i < length; i++) {
				if (! e.MoveNext()) {
					throw new ArgumentException("source ̖ɒB܂B");
				}
				try {
					destination[destinationIndex + i] = (destinationType == null ?
							e.Current : ObjectUtil.ChangeType(e.Current, destinationType));
				} catch (ArgumentOutOfRangeException) {
					throw new ArgumentException("destination ̖ɒB܂B");
				}
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		private static IEnumerable<T> FindAllInternal<T>(IEnumerable e, Predicate<T> match)
		{
			foreach (T obj in e) {
				if (match(obj)) {
					yield return obj;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="hashFunction"></param>
		/// <param name="comparison"></param>
		/// <returns></returns>
		private static IEnumerable<IEnumerable<T>> FindSameInternal<T>(
				IEnumerable<T> e, Func<T, int> hashFunction, EqualityComparison<T> comparison)
		{
			var hashDic = new MultipleDictionary<int, T>(CreateGenericList<T>);
			foreach (T obj in e) {
				hashDic.Add(hashFunction(obj), obj);
			}
			IList<IEnumerable<T>> result = new List<IEnumerable<T>>();
			foreach (IList<T> list in hashDic.Values) {
				for (;;) {
					int count = list.Count;
					if (count == 0) {
						break;
					}
					T lastItem = list[count - 1];
					list.RemoveAt(count - 1);
					IList<T> sameList = PickUpInternal(
							list, lastItem, comparison, CreateGenericList<T>);
					if (sameList != null) {
						sameList.Insert(0, lastItem);
						result.Add(sameList);
					}
				}
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		private static bool IsEnumerationNeeded(object obj)
		{
			return obj is IEnumerable && ! (obj is string);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TElement"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="e"></param>
		/// <param name="valueGetter"></param>
		/// <param name="comparison"></param>
		/// <param name="selector"></param>
		/// <returns></returns>
		private static TElement MaxMinInternal<TElement, TValue>(
				IEnumerable e, Func<TElement, TValue> valueGetter,
				Comparison<TValue> comparison, Func<int, TElement, TElement, TElement> selector)
		{
			ArgumentUtil.AssertNull(e, "e");
			ArgumentUtil.AssertNull(comparison, "comparison");
			valueGetter = valueGetter ?? ObjectUtil.Cast<TElement, TValue>;
			return Select<TElement>(e, (x, y) => {
				int compare = comparison(valueGetter(x), valueGetter(y));
				return selector(compare, x, y);
			});
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oāAVXg쐬܂B
		/// </summary>
		/// <param name="list">vf𔲂oXgB</param>
		/// <param name="value">Xg甲olB</param>
		/// <param name="comparison">vf̒lrۂɗp EqualityComparisonB</param>
		/// <param name="createList">Xg쐬ۂɗp ListGeneratorB</param>
		/// <returns></returns>
		private static IList PickUpInternal(IList list,
				object value, EqualityComparison comparison, Func<IList> createList)
		{
			IList result = null;
			for (int i = list.Count - 1; i >= 0; i--) {
				if (comparison(value, list[i])) {
					result = result ?? createList();
					result.Add(list[i]);
					list.RemoveAt(i);
				}
			}
			return result;
		}

		/// <summary>
		/// Xgw肵lɓvf𔲂oāAVXg쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="list">vf𔲂oXgB</param>
		/// <param name="value">Xg甲olB</param>
		/// <param name="comparison">vf̒lrۂɗp EqualityComparisonB</param>
		/// <param name="createList">Xg쐬ۂɗp ListGeneratorB</param>
		/// <returns></returns>
		private static IList<T> PickUpInternal<T>(IList<T> list,
				T value, EqualityComparison<T> comparison, Func<IList<T>> createList)
		{
			IList<T> result = null;
			for (int i = list.Count - 1; i >= 0; i--) {
				if (comparison(value, list[i])) {
					result = result ?? createList();
					result.Add(list[i]);
					list.RemoveAt(i);
				}
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="compare"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		private static T SelectGreater<T>(int compare, T x, T y)
		{
			return compare > 0 ? x : y;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="compare"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		private static T SelectLess<T>(int compare, T x, T y)
		{
			return compare < 0 ? x : y;
		}
	}
}
