using System;
using System.ComponentModel;

namespace SystemNeo
{
	/// <summary>
	/// \bḧɓnꂽl`FbN郁\bh񋟂܂B
	/// </summary>
	public static class ArgumentUtil
	{
		/// <summary>
		/// \bh̗񋓌^̈ɓnꂽl̗񋓎qƂđ݂邱Ƃ`FbN܂B
		/// </summary>
		/// <param name="value">̒lB</param>
		/// <param name="argumentName">̖OB</param>
		public static void AssertInvalidEnum(Enum value, string argumentName)
		{
			Type type = value.GetType();
			if (! Enum.IsDefined(type, value)) {
				throw new InvalidEnumArgumentException(argumentName, Convert.ToInt32(value), type);
			}
		}

		/// <summary>
		/// \bḧɓnꂽl null QƂłȂƂ`FbN܂B
		/// </summary>
		/// <param name="value">̒lB</param>
		/// <param name="argumentName">̖OB</param>
		/// <exception cref="System.ArgumentNullException"><paramref name="value"/>  null QƂłB</exception>
		public static void AssertNull(object value, string argumentName)
		{
			if (value == null) {
				throw new ArgumentNullException(argumentName);
			}
		}

		/// <summary>
		/// \bḧɓnꂽlw肳ꂽꂩ̌^ɕϊł邱Ƃ`FbN܂B
		/// </summary>
		/// <param name="value">̒lB</param>
		/// <param name="argumentName">̖OB</param>
		/// <param name="argumentTypes"></param>
		/// <exception cref="System.ArgumentException">
		/// <paramref name="value"/>  <paramref name="argumentTypes"/> ̂̌^ɂϊł܂B
		/// </exception>
		public static void AssertType(
				object value, string argumentName, params Type[] argumentTypes)
		{
			if (value == null) {
				return;
			}
			Type valueType = value.GetType();
			foreach (Type t in argumentTypes) {
				if (t.IsAssignableFrom(valueType)) {
					return;
				}
			}
			string msg;
			if (argumentTypes.Length == 1) {
				msg = string.Format("^ {0}  {1} hĂ܂B",
						valueType.FullName, argumentTypes[0].FullName);
			} else {
				msg = string.Format("^ {0} ͂̃p[^ɂ͎gpł܂B", valueType.FullName);
			}
			throw new ArgumentException(msg, argumentName);
		}

		/// <summary>
		/// \bḧɓnꂽľ^ɕϊł邱Ƃ`FbN܂B
		/// </summary>
		/// <typeparam name="T">̒lϊł邱Ƃ`FbN^B</typeparam>
		/// <param name="value">̒lB</param>
		/// <param name="argumentName">̖OB</param>
		/// <returns>ϊꂽ̒lB</returns>
		/// <exception cref="System.ArgumentException">
		/// <paramref name="value"/> ^ <typeparamref name="T"/> ɕϊł܂B
		/// </exception>
		public static T ValidateType<T>(object value, string argumentName)
		{
			AssertType(value, argumentName, typeof(T));
			return (T)value;
		}

		/// <summary>
		/// \bḧɓnꂽľ^ɕϊł邱Ƃ`FbN܂B
		/// </summary>
		/// <typeparam name="T">̒lϊł邱Ƃ`FbN^B</typeparam>
		/// <param name="value">̒lB</param>
		/// <param name="argumentName">̖OB</param>
		/// <param name="validated">ϊꂽ̒li[ϐB</param>
		/// <exception cref="System.ArgumentException">
		/// <paramref name="value"/> ^ <typeparamref name="T"/> ɕϊł܂B
		/// </exception>
		public static void ValidateType<T>(object value, string argumentName, out T validated)
		{
			validated = ValidateType<T>(value, argumentName);
		}
	}
}
