using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace SystemNeo.Windows
{
	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
	internal struct SHFILEOPSTRUCT
	{
		#region private fields
		private readonly IntPtr hwnd;
		private readonly SHFileOperationFunc wFunc;
		[MarshalAs(UnmanagedType.LPTStr)]
		private readonly string pFrom;
		[MarshalAs(UnmanagedType.LPTStr)]
		private readonly string pTo;
		private readonly SHFileOperationFlags fFlags;
		private bool fAnyOperationsAborted;
		private readonly IntPtr hNameMappings;
		[MarshalAs(UnmanagedType.LPTStr)]
		private readonly string lpszProgressTitle;
		#endregion

		// internal vpeB //

		/// <summary>
		/// 
		/// </summary>
		internal bool AnyOperationsAborted
		{
			get {
				return this.fAnyOperationsAborted;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="func"></param>
		/// <param name="from"></param>
		/// <param name="to"></param>
		/// <param name="flags"></param>
		/// <param name="progressTitle"></param>
		internal SHFILEOPSTRUCT(Control control, SHFileOperationFunc func,
				string from, string to, SHFileOperationFlags flags, string progressTitle)
				: this(control, func, from, to, flags, IntPtr.Zero, progressTitle) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="func"></param>
		/// <param name="from"></param>
		/// <param name="to"></param>
		/// <param name="flags"></param>
		/// <param name="nameMappings"></param>
		/// <param name="progressTitle"></param>
		internal SHFILEOPSTRUCT(Control control, SHFileOperationFunc func, string from,
				string to, SHFileOperationFlags flags, IntPtr nameMappings, string progressTitle)
		{
			this.hwnd = (control == null ? IntPtr.Zero : control.Handle);
			this.wFunc = func;
			this.pFrom = from;
			this.pTo = to;
			this.fFlags = flags;
			this.fAnyOperationsAborted = false;
			this.hNameMappings = nameMappings;
			this.lpszProgressTitle = progressTitle;
		}
	}
}
