using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// 
	/// </summary>
	public class DragStartManager : Component
	{
		#region private fields

		private Control control;
		private int threshold = 8;

		private bool mouseDown;
		private int x;
		private int y;

		#endregion

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event DragDropEventHandler DragDrop;

		/// <summary>
		/// 
		/// </summary>
		public event DragStartEventHandler DragStart;

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public Control Control
		{
			get {
				return this.control;
			}
			set {
				if (this.control != null) {
					this.RemoveHandlers();
				}
				this.mouseDown = false;
				this.control = value;
				if (this.control != null) {
					this.AddHandlers();
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(8)]
		public int Threshold
		{
			get {
				return this.threshold;
			}
			set {
				this.threshold = value;
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose(bool disposing)
		{
			this.Control = null;
			base.Dispose(disposing);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MouseDown(object sender, MouseEventArgs e)
		{
			this.mouseDown = true;
			this.x = e.X;
			this.y = e.Y;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MouseMove(object sender, MouseEventArgs e)
		{
			if (this.mouseDown) {
				if (Math.Min(Math.Abs(e.X - this.x), Math.Abs(e.Y - this.y)) > this.threshold) {
					var dsea = new DragStartEventArgs(e.Button, this.x, this.y);
					this.DragStart(this, dsea);
					if (dsea.Data != null) {
						this.mouseDown = false;
						DragDropEffects result
								= this.control.DoDragDrop(dsea.Data, dsea.AllowedEffects);
						var ddea = new DragDropEventArgs(result);
						this.DragDrop(this, ddea);
					}
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MouseUp(object sender, MouseEventArgs e)
		{
			this.mouseDown = false;
		}

		/// <summary>
		/// 
		/// </summary>
		private void AddHandlers()
		{
			this.control.MouseDown += this.MouseDown;
			this.control.MouseMove += this.MouseMove;
			this.control.MouseUp += this.MouseUp;
		}

		/// <summary>
		/// 
		/// </summary>
		private void RemoveHandlers()
		{
			this.control.MouseDown -= this.MouseDown;
			this.control.MouseMove -= this.MouseMove;
			this.control.MouseUp -= this.MouseUp;
		}
	}
}
