using System;
using System.ComponentModel;
using System.Globalization;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// l͂邽߂̃eLXg{bNXłB
	/// </summary>
	public class DecimalTextBox : TextBoxEx
	{
		#region private fields
		private string defaultFormat = "N";
		private NumberFormatInfo formatInfo = NumberFormatInfo.InvariantInfo;
		private NumberStyles style = NumberStyles.AllowDecimalPoint
								   | NumberStyles.AllowLeadingSign
								   | NumberStyles.AllowThousands;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue("N")]
		public string DefaultFormat
		{
			get {
				return this.defaultFormat;
			}
			set {
				this.defaultFormat = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public NumberFormatInfo FormatInfo
		{
			get {
				return this.formatInfo;
			}
			set {
				this.formatInfo = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[Browsable(false)]
		[DefaultValue(ImeMode.Disable)]
		protected new ImeMode ImeMode
		{
			get {
				return base.ImeMode;
			}
			set {
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(NumberStyles.AllowDecimalPoint
					| NumberStyles.AllowLeadingSign
					| NumberStyles.AllowThousands)]
		public NumberStyles Style
		{
			get {
				return this.style;
			}
			set {
				this.style = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[Browsable(false)]
		public override object Value
		{
			get {
				return this.GetValue();
			}
			set {
				if (IsNull(value)) {
					this.Text = string.Empty;
				} else if (value is Decimal) {
					this.Text = this.Format((Decimal)value);
				} else {
					try {
						Decimal d = this.Parse(value.ToString());
						this.Value = d;
					} catch (FormatException) {
						throw new ArgumentException();
					}
				}
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public DecimalTextBox()
		{
			base.ImeMode = ImeMode.Disable;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		protected override bool AcceptChar(char c)
		{
			switch (c) {
			case CharUtil.Backspace:
			case CharUtil.Comma:
			case CharUtil.Dot:
			case CharUtil.Minus:
			case CharUtil.Plus:
				return true;
			default:
				return CharUtil.IsAsciiDigit(c);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		protected string Format(decimal value)
		{
			if (this.defaultFormat == string.Empty) {
				return value.ToString();
			} else {
				return value.ToString(this.defaultFormat, this.formatInfo);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected object GetValue()
		{
			if (this.Text == null) {
				return DBNull.Value;
			} else {
				return this.Parse(this.Text);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnValidating(CancelEventArgs e)
		{
			try {
				object value = this.GetValue();
				if (value is Decimal) {
					this.Text = this.Format((Decimal)value);
				}

			} catch (FormatException) {
				e.Cancel = true;
			}
			base.OnValidating(e);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		protected decimal Parse(string value)
		{
			return Decimal.Parse(value, this.style, this.formatInfo);
		}
	}
}
