using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// ObhŃC[W\\܂B
	/// </summary>
	public class DataGridImageColumn : DataGridColumnStyle
	{
		#region private fields
		private Color backColor = SystemColors.Window;
		private bool drawDefault = true;
		private bool fillBackColor = true;
		#endregion

		// public vpeB //

		/// <summary>
		/// wiF擾܂͐ݒ肵܂B
		/// </summary>
		public Color BackColor
		{
			get {
				return this.backColor;
			}
			set {
				if (this.backColor != value) {
					this.backColor = value;
					this.Invalidate();
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(true)]
		public bool DrawDefault
		{
			get {
				return this.drawDefault;
			}
			set {
				if (this.drawDefault != value) {
					this.drawDefault = value;
					this.Invalidate();
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(true)]
		public bool FillBackColor
		{
			get {
				return this.fillBackColor;
			}
			set {
				if (this.fillBackColor != value) {
					this.fillBackColor = value;
					this.Invalidate();
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(0)]
		public int MinimumHeight { get; set; }

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event DrawCellEventHandler DrawCell;

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="rowNum"></param>
		protected override void Abort(int rowNum) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dataSource"></param>
		/// <param name="rowNum"></param>
		/// <returns></returns>
		protected override bool Commit(CurrencyManager dataSource, int rowNum)
		{
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="rowNum"></param>
		/// <param name="bounds"></param>
		/// <param name="readOnly"></param>
		/// <param name="displayText"></param>
		/// <param name="cellIsVisible"></param>
		protected override void Edit(CurrencyManager source, int rowNum,
				Rectangle bounds, bool readOnly, string displayText, bool cellIsVisible) {}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override int GetMinimumHeight()
		{
			return this.MinimumHeight;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="g"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		protected override int GetPreferredHeight(Graphics g, object value)
		{
			return this.GetPreferredSize(g, value).Height;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="g"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		protected override Size GetPreferredSize(Graphics g, object value)
		{
			return new Size(0, 0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="g"></param>
		/// <param name="bounds"></param>
		/// <param name="source"></param>
		/// <param name="rowNum"></param>
		protected override void Paint(
				Graphics g, Rectangle bounds, CurrencyManager source, int rowNum)
		{
			this.Paint(g, bounds, source, rowNum, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="g"></param>
		/// <param name="bounds"></param>
		/// <param name="source"></param>
		/// <param name="rowNum"></param>
		/// <param name="alignToRight"></param>
		protected override void Paint(Graphics g,
				Rectangle bounds, CurrencyManager source, int rowNum, bool alignToRight)
		{
			if (this.fillBackColor) {
				// wihԂ
				g.FillRectangle(new SolidBrush(this.backColor), bounds);
			}
			bool gotValue = false;
			object value = null;
			bool drawDefault = this.drawDefault;
			// DrawCell CxgnhH
			if (this.DrawCell != null) {
				value = this.GetColumnValueAtRow(source, rowNum);
				gotValue = true;
				var args = new DrawCellEventArgs(
						g, bounds, source, rowNum, alignToRight, value, drawDefault);
				this.DrawCell(this, args);
				drawDefault = args.DrawDefault;
			}
			if (drawDefault) {
				if (! gotValue) {
					value = this.GetColumnValueAtRow(source, rowNum);
				}
				if (value is Image) {
					// l Image IuWFNgȂ΁A`悷
					g.DrawImageUnscaledAndClipped((Image)value, bounds);
				}
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public class DrawCellEventArgs : EventArgs
		{
			// public vpeB //

			/// <summary>
			/// 
			/// </summary>
			public bool AlignToRight { get; private set; }

			/// <summary>
			/// 
			/// </summary>
			public Rectangle Bounds { get; private set; }

			/// <summary>
			/// 
			/// </summary>
			public bool DrawDefault { get; set; }

			/// <summary>
			/// 
			/// </summary>
			public Graphics Graphics { get; private set; }

			/// <summary>
			/// 
			/// </summary>
			public int RowNum { get; private set; }

			/// <summary>
			/// 
			/// </summary>
			public CurrencyManager Source { get; private set; }

			/// <summary>
			/// 
			/// </summary>
			public object Value { get; private set; }

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="graphics"></param>
			/// <param name="bounds"></param>
			/// <param name="source"></param>
			/// <param name="rowNum"></param>
			/// <param name="alignToRight"></param>
			/// <param name="value"></param>
			/// <param name="drawDefault"></param>
			internal DrawCellEventArgs(
					Graphics graphics, Rectangle bounds, CurrencyManager source,
					int rowNum, bool alignToRight, object value, bool drawDefault)
			{
				this.Graphics = graphics;
				this.Bounds = bounds;
				this.Source = source;
				this.RowNum = rowNum;
				this.AlignToRight = alignToRight;
				this.Value = value;
				this.DrawDefault = drawDefault;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public delegate void DrawCellEventHandler(object sender, DrawCellEventArgs e);
	}
}
