using System;
using System.IO;
using System.Text;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class TextDescription
	{
		#region private fields
		private readonly int asciiLength;
		private readonly byte[] asciiBytes;
		private readonly int unicodeLanguageCode;
		private readonly int unicodeLength;
		private readonly byte[] unicodeBytes;
		private readonly Encoding unicodeEncoding;
		private readonly ushort scriptCode;
		private readonly byte scriptLength;
		private readonly byte[] scriptBytes;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string AsciiText
		{
			get {
				return Encoding.Default.GetString(this.asciiBytes).TrimEnd(CharUtil.Null);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string UnicodeText
		{
			get {
				return this.unicodeEncoding.GetString(this.unicodeBytes);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string ScriptText
		{
			get {
				return Encoding.Default.GetString(this.scriptBytes).TrimEnd(CharUtil.Null);
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal TextDescription(BinaryReaderNeo reader)
		{
			this.asciiLength = reader.ReadInt32();
			this.asciiBytes = reader.ReadBytes(this.asciiLength);
			this.unicodeLanguageCode = reader.ReadInt32();
			this.unicodeLength = reader.ReadInt32();
			this.unicodeBytes = reader.ReadBytes(this.unicodeLength);
			if (this.unicodeLanguageCode == 0 && this.unicodeLength >= 2
					&& this.unicodeBytes[0] == 0xFE && this.unicodeBytes[1] == 0xFF) {
				this.unicodeEncoding = Encoding.BigEndianUnicode;
			} else {
				this.unicodeEncoding = Encoding.GetEncoding(this.unicodeLanguageCode);
			}
			this.scriptCode = reader.ReadUInt16();
			this.scriptLength = reader.ReadByte();
			this.scriptBytes = reader.ReadBytes(this.scriptLength);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var qsf = new QuotedStringFormatter();
			var sw = new StringWriter();
			sw.Write("{AsciiText=");
			qsf.WriteTo(sw, this.AsciiText);
			sw.Write(", Language=");
			sw.Write(this.unicodeLanguageCode);
			if (this.UnicodeText != null && this.UnicodeText.Length > 0) {
				sw.Write(", UnicodeText=");
				qsf.WriteTo(sw, this.UnicodeText);
			}
			sw.Write(", ScriptCode=");
			sw.Write(this.scriptCode);
			sw.Write(", ScriptText=");
			if (this.ScriptText == this.AsciiText) {
				sw.Write("AsciiText");
			} else {
				qsf.WriteTo(sw, this.ScriptText);
			}
			sw.Write("}");
			return sw.ToString();
		}
	}
}
