using System;
using System.Globalization;
using System.IO;
using System.Text;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class LocalizedStringCollection
	{
		#region private static fields
		private static readonly CollectionFormatter recordsFormatter = new CollectionFormatter() {
			BeginBracket = "[" + Environment.NewLine + "\t\t",
			EndBracket = Environment.NewLine + "\t]",
			Separator = "," + Environment.NewLine + "\t\t"
		};
		#endregion

		#region private fields
		private readonly int recordCount;
		private readonly LocalizedString[] records;
		#endregion

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal LocalizedStringCollection(BinaryReaderNeo reader)
		{
			long basePosition = reader.Position - 8;
			this.recordCount = reader.ReadInt32();
			uint recordSize = reader.ReadUInt32();
			this.records = new LocalizedString[this.recordCount];
			for (int i = 0; i < this.recordCount; i++) {
				this.records[i] = new LocalizedString(reader, basePosition);
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			if (this.recordCount == 0) {
				return "none";
			} else {
				return recordsFormatter.ToString(this.records);
			}
		}
	}
}
