using System;
using System.Collections.Generic;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	internal static class IccUtil
	{
		// internal static tB[h //

		/// <summary>
		/// 
		/// </summary>
		internal static readonly CollectionFormatter fractionArrayFormatter
				= new CollectionFormatter(FractionFormatter.Default);
		
		/// <summary>
		/// 
		/// </summary>
		internal static readonly IDictionary<string, string> profileClassDic
				= new Dictionary<string, string>() {
					{"abst", "AbstractProfile"},
					{"link", "DeviceLinkProfile"},
					{"mntr", "DisplayDeviceProfile"},
					{"nmcl", "NamedColorProfile"},
					{"prtr", "OutputDeviceProfile"},
					{"scnr", "InputDeviceProfile"},
					{"spac", "ColorSpaceConversionProfile"}
				};

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <returns></returns>
		internal static string Read4Chars(BinaryReaderNeo reader)
		{
			return reader.ReadString(4).Trim(' ', '\0');
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <returns></returns>
		internal static DateTime ReadDateTime(BinaryReaderNeo reader)
		{
			ushort[] arr = reader.ReadUInt16s(6);
			if (arr[1] >= 1900) {
				// Nƌ̏tɂȂĂAёւ
				ushort tmp = arr[0];
				arr[0] = arr[1];
				arr[1] = tmp;
			}
			return new DateTime(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <returns></returns>
		internal static Fraction ReadFraction(BinaryReaderNeo reader)
		{
			return ReadFractions(reader, 1)[0];
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <param name="count"></param>
		/// <returns></returns>
		internal static Fraction[] ReadFractions(BinaryReaderNeo reader, int count)
		{
			var result = new Fraction[count];
			for (int i = 0; i < count; i++) {
				result[i] = new Fraction(reader.ReadInt32(), 0x10000);
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <returns></returns>
		internal static string ReadVersion(BinaryReaderNeo reader)
		{
			byte[] a = reader.ReadBytes(4);
			byte b;
			byte c;
			ObjectUtil.SplitBits(a[1], out b, out c);
			return string.Format("{0}.{1}.{2}", a[0], b, c);
		}
	}
}
