using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class IccProfileHeader
	{
		#region private static fields
		private const int profileIdLength = 16;
		private static readonly IDictionary<string, string> platformDic
				= new Dictionary<string, string>() {
					{"APPL", "Apple Computer Inc."},
					{"MSFT", "Microsoft Corporation"},
					{"SGI",  "Silicon Graphics Inc."},
					{"SUNW", "Sun Microsystems Inc."},
					{"TGNT", "Taligent Inc."}
				};
		#endregion

		#region private fields
		private readonly uint size;
		private readonly string profileClassCode;
		private readonly string primaryPlatformCode;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public CmmFlags CmmFlags { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ColorSpaceData { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Fraction[] ConnectionSpaceIlluminant { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public DeviceAttributes DeviceAttributes { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string DeviceManufacturer { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string DeviceModel { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string PrimaryPlatform { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileClass { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileCmmType { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileConnectionSpace { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileCreator { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public DateTime ProfileDateTime { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileFileSignature { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public byte[] ProfileId { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string ProfileVersion { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public RenderingIntent RenderingIntent { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name='reader'></param>
		internal IccProfileHeader(BinaryReaderNeo reader, long basePosition)
		{
			// basePosition + 0
			this.size = reader.ReadUInt32();
			if (this.size > reader.Length - basePosition) {
				string msg = string.Format("TCY傫܂B"
						+ "size=[{0:N0}] reader.Length=[{1:N0}]", this.size, reader.Length);
				throw new BadImageFormatException(msg);
			}
			// basePosition + 4
			this.ProfileCmmType = IccUtil.Read4Chars(reader);
			this.ProfileVersion = IccUtil.ReadVersion(reader);
			this.profileClassCode = IccUtil.Read4Chars(reader);
			if (! profileClassCode.Contains(this.profileClassCode)) {
				string msg = "APP2̃vt@CNXsłB"
						+ new QuotedStringFormatter().ToString(this.profileClassCode);
				throw new BadImageFormatException(msg);
			}
			this.ProfileClass = IccUtil.profileClassDic[this.profileClassCode];
			// basePosition + 16
			this.ColorSpaceData = IccUtil.Read4Chars(reader);
			this.ProfileConnectionSpace = IccUtil.Read4Chars(reader);
			// basePosition + 24
			this.ProfileDateTime = IccUtil.ReadDateTime(reader);
			// basePosition + 36
			this.ProfileFileSignature = IccUtil.Read4Chars(reader);
			this.primaryPlatformCode = IccUtil.Read4Chars(reader);
			this.PrimaryPlatform = platformDic[this.primaryPlatformCode];
			// basePosition + 44
			this.CmmFlags = (CmmFlags)reader.ReadUInt32();
			this.DeviceManufacturer = IccUtil.Read4Chars(reader);
			this.DeviceModel = IccUtil.Read4Chars(reader);
			this.DeviceAttributes = (DeviceAttributes)reader.ReadUInt32();
			string dummy2 = IccUtil.Read4Chars(reader);
			// basePosition + 64
			this.RenderingIntent = (RenderingIntent)reader.ReadUInt32();
			this.ConnectionSpaceIlluminant = IccUtil.ReadFractions(reader, 3);
			// basePosition + 80
			this.ProfileCreator = IccUtil.Read4Chars(reader);
			this.ProfileId = reader.ReadBytes(profileIdLength);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Size=");
			sw.Write(this.size.ToString("N0"));
			sw.Write(", ProfileCmmType=");
			sw.Write(this.ProfileCmmType);
			sw.Write(", ProfileVersion=");
			sw.Write(this.ProfileVersion);
			sw.Write(", ProfileClass=");
			sw.Write(this.ProfileClass);
			sw.Write(", ColorSpaceData=");
			sw.Write(this.ColorSpaceData);
			sw.Write(", ProfileConnectionSpace=");
			sw.Write(this.ProfileConnectionSpace);
			sw.Write(", ProfileDateTime=");
			sw.Write(this.ProfileDateTime.ToString("yyyy/M/d H:mm:ss"));
			sw.Write(", ProfileFileSignature=");
			sw.Write(this.ProfileFileSignature);
			sw.Write(", PrimaryPlatform=");
			sw.Write(this.PrimaryPlatform);
			sw.Write(", CmmFlags=");
			sw.Write(EnumUtil.ToString(this.CmmFlags));
			sw.Write(", DeviceManufacturer=");
			sw.Write(this.DeviceManufacturer);
			sw.Write(", DeviceModel=");
			sw.Write(this.DeviceModel);
			sw.Write(", DeviceAttributes=");
			sw.Write(EnumUtil.ToString(this.DeviceAttributes));
			sw.Write(", RenderingIntent=");
			sw.Write(this.RenderingIntent);
			sw.Write(", ConnectionSpaceIlluminant=");
			IccUtil.fractionArrayFormatter.WriteTo(sw, this.ConnectionSpaceIlluminant);
			sw.Write(", ProfileCreator=");
			sw.Write(this.ProfileCreator);
			sw.Write(", ProfileId=");
			new ByteArrayFormatter().WriteTo(sw, this.ProfileId);
			sw.Write("}");
			return sw.ToString();
		}
	}
}
