#pragma once

#include "Content.h"
#include <Poco/Logger.h>
#include <Poco/Mutex.h>
#include <vector>

using std::vector;


/**
 * Content܂Content̃Rei
 */
class Container: public Content
{
private:
	Poco::FastMutex _lock;
	vector<ContentPtr> _list;

	bool _initialized;

public:
	/** RXgN^ */
	Container(Renderer& renderer);

	/** fXgN^ */
	virtual ~Container();

	/**  */
	void initialize();

	/**
	 * ReiContentǉ܂
	 * @param c	ǉRec
	 */
	void add(ContentPtr c);

	/** zŃANZX */
	ContentPtr operator[](int i);

	/**
	 * w肵CfbNX̃RecԂ܂
	 * @param i	CfbNXԍ
	 */
	ContentPtr get(int i);

	/** Rec */
	int size();

	/**
	 * openςǂ
	 * @return	I[vĂRecID
	 */
	const string opened();

	/** Đ */
	void play();

	/** |[Y */
	void pause();

	/** ~ */
	void stop();

	/** ~ɂܒ~邩ǂ */
	bool useFastStop();

	/** o */
	void rewind();

	/**
	 * Iǂ
	 * @return	IĂtrueA܂Ȃfalse
	 */
	const bool finished();

	/**
	 * L[ʒm
	 * @param	keycide	L[R[h
	 * @param	shift	SHIFTL[̉tO
	 * @param	ctrl	CTRLL[̉tO
	 */
	void notifyKey(const int keycode, const bool shift, const bool ctrl);

	/** `ȊȌ */
	void process(const DWORD& frame);

	/** `揈 */
	void draw(const DWORD& frame);

	/** vr[ */
	void preview(const DWORD& frame);

	/** ݂̍Đt[ */
	const int current();

	/** t[ */
	const int duration();

	/** vpeB̐ݒ */
	void setProperty(const string& key, const string& value);
};

typedef Container* ContainerPtr;