#pragma once

#include <string>
#include <vector>
#include <Poco/format.h>
#include <Poco/Logger.h>

#include "UserInterfaceManager.h"

using std::vector;
using std::string;


namespace ui {

	class Component
	{
	private:
		vector<Component*> _child;

	protected:
		Poco::Logger& _log;
		string _name;
		UserInterfaceManagerPtr _uim;

		bool _enabled;
		int _x, _y, _w, _h;
		float _alpha;

		DWORD _color;
		DWORD _background;
		DWORD _border;

	public:
		Component(string name, UserInterfaceManagerPtr uim, int x, int y, int w, int h, float alpha);

		virtual ~Component(void);

		UserInterfaceManagerPtr getUserInterfaceManager();

		/** Lǂ */
		bool getEnabled() const;

		void setEnabled(bool enabled);

		/** J[ݒ */
		void setColor(const DWORD color);

		/** wiFݒ */
		void setBackground(const DWORD color);

		/** ʒuݒ */
		void setPosition(int x, int y);
		void setX(int x);
		void setY(int y);

		/** TCYݒ */
		void setSize(int w, int h);

		/** ʒu擾 */
		int getX();
		int getY();

		/** TCY擾 */
		int getWidth();
		int getHeight();

		/** TuR|[lgǉ */
		void add(Component* ui);

		/** wWR|[lgǂ */
		bool contains(int x, int y);

		/** process̑OB1t[1x */
		virtual void preprocess(const DWORD& frame);

		/** 1t[1x */
		virtual void process(const DWORD& frame);

		/** procesš㏈B1t[1x */
		virtual void postprocess(const DWORD& frame);

		/** ` */
		virtual void draw(const DWORD& frame);
	};

	typedef Component* ComponentPtr;
}
