#pragma once

#include "Renderer.h"
#include "Workspace.h"
#include <string>
#include <map>

using std::string;
using std::map;


/**
 * V[NX.
 * `@\̂܂Ƃ܂̒P.
 */
class Scene
{
protected:
	Poco::Logger& _log;
	Renderer& _renderer;
	bool _visible;
	int _keycode;
	bool _shift;
	bool _ctrl;

	/** Xe[^Xp̃}bv */
	map<string, string> _status;

public:
	Scene(Renderer& renderer);

	virtual ~Scene();

	Renderer& renderer();

	virtual bool initialize();

	/** \/\̐ݒ */
	void setVisible(const bool visible);

	virtual void notifyKey(const int keycode, const bool shift, const bool ctrl);

	/** Xe[^X̐ݒ */
	virtual void setStatus(const string& key, const string& value);

	/** Xe[^X̎擾 */
	virtual const map<string, string>& getStatus();

	/** Xe[^X̎擾 */
	virtual const string getStatus(const string& key);

	/** Xe[^X̍폜 */
	virtual void removeStatus(const string& key);

	virtual void process();

	virtual void processAlways();

	virtual void draw1();

	virtual void draw2();
};

typedef Scene* ScenePtr;