/*
  This program is a conversion from original Swiss Ephemeris Software.
*/
/* Copyright (C) 1997, 1998 Astrodienst AG, Switzerland.  All rights reserved.
  
  This file is part of Swiss Ephemeris Free Edition.
  
  Swiss Ephemeris is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Swiss Ephemeris Public License
  ("SEPL" or the "License") for full details.
  
  Every copy of Swiss Ephemeris must include a copy of the License,
  normally in a plain ASCII text file named LICENSE.  The License grants you
  the right to copy, modify and redistribute Swiss Ephemeris, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notices and this notice be preserved on
  all copies.

  For uses of the Swiss Ephemeris which do not fall under the definitions
  laid down in the Public License, the Swiss Ephemeris Professional Edition
  must be purchased by the developer before he/she distributes any of his
  software or makes available any product or service built upon the use of
  the Swiss Ephemeris.

  Authors of the Swiss Ephemeris: Dieter Koch and Alois Treindl

  The authors of Swiss Ephemeris have no control or influence over any of
  the derived works, i.e. over software or services created by other
  programmers which use Swiss Ephemeris functions.

  The names of the authors or of the copyright holder (Astrodienst) must not
  be used for promoting any software, product or service which uses or contains
  the Swiss Ephemeris. This copyright notice is the ONLY place where the
  names of the authors can legally appear, except in cases where they have
  given special permission in writing.

  The trademarks 'Swiss Ephemeris' and 'Swiss Ephemeris inside' may be used
  for promoting such software, products or services.
*/

package jp.co.isic.SwissEphemeris;

//import java.lang.*;
//import java.io.*;

public abstract class SwissEphemeris {
  /* values for gregflag in swe_julday() and swe_revjul() */
  public static final int SE_JUL_CAL = 0;
  public static final int SE_GREG_CAL = 1;

  /* planet numbers for the ipl parameter in swe_calc() */
  public static final int SE_ECL_NUT = -1;

  public static final int SE_SUN = 0;
  public static final int SE_MOON = 1;
  public static final int SE_MERCURY = 2;
  public static final int SE_VENUS = 3;
  public static final int SE_MARS = 4;
  public static final int SE_JUPITER = 5;
  public static final int SE_SATURN = 6;
  public static final int SE_URANUS = 7;
  public static final int SE_NEPTUNE = 8;
  public static final int SE_PLUTO = 9;
  public static final int SE_MEAN_NODE = 10;
  public static final int SE_TRUE_NODE = 11;
  public static final int SE_MEAN_APOG = 12;
  public static final int SE_OSCU_APOG = 13;
  public static final int SE_EARTH = 14;
  public static final int SE_CHIRON = 15;
  public static final int SE_PHOLUS = 16;
  public static final int SE_CERES = 17;
  public static final int SE_PALLAS = 18;
  public static final int SE_JUNO = 19;
  public static final int SE_VESTA = 20;

  public static final int SE_NPLANETS = 21;

  public static final int SE_AST_OFFSET = 10000;
  public static final int SE_VARUNA = (SE_AST_OFFSET + 20000);

  public static final int SE_FICT_OFFSET = 40;
  public static final int SE_FICT_OFFSET_1 = 39;
  public static final int SE_FICT_MAX = 999;
  public static final int SE_NFICT_ELEM = 19;

  public static final int SE_COMET_OFFSET = 1000;

  public static final int SE_NALL_NAT_POINTS = (SE_NPLANETS + SE_NFICT_ELEM);

  /* Hamburger or Uranian "planets" */
  public static final int SE_CUPIDO = 40;
  public static final int SE_HADES = 41;
  public static final int SE_ZEUS = 42;
  public static final int SE_KRONOS = 43;
  public static final int SE_APOLLON = 44;
  public static final int SE_ADMETOS = 45;
  public static final int SE_VULKANUS = 46;
  public static final int SE_POSEIDON = 47;
  /* other fictitious bodies */
  public static final int SE_ISIS = 48;
  public static final int SE_NIBIRU = 49;
  public static final int SE_HARRINGTON = 50;
  public static final int SE_NEPTUNE_LEVERRIER = 51;
  public static final int SE_NEPTUNE_ADAMS = 52;
  public static final int SE_PLUTO_LOWELL = 53;
  public static final int SE_PLUTO_PICKERING = 54;
  public static final int SE_VULCAN = 55;
  public static final int SE_WHITE_MOON = 56;
  public static final int SE_PROSERPINA = 57;
  public static final int SE_WALDEMATH = 58;

  public static final int SE_FIXSTAR = -10;

  public static final int SE_ASC = 0;
  public static final int SE_MC = 1;
  public static final int SE_ARMC = 2;
  public static final int SE_VERTEX = 3;
  public static final int SE_EQUASC = 4; /* "equatorial ascendant" */
  public static final int SE_COASC1 = 5; /* "co-ascendant" (W. Koch) */
  public static final int SE_COASC2 = 6; /* "co-ascendant" (M. Munkasey) */
  public static final int SE_POLASC = 7; /* "polar ascendant" (M. Munkasey) */
  public static final int SE_NASCMC = 8;

/*
 * flag bits for parameter iflag in function swe_calc()
 * The flag bits are defined in such a way that iflag = 0 delivers what one
 * usually wants:
 *    - the default ephemeris (SWISS EPHEMERIS) is used,
 *    - apparent geocentric positions referring to the true equinox of date
 *      are returned.
 * If not only coordinates, but also speed values are required, use 
 * flag = SEFLG_SPEED.
 *
 * The 'L' behind the number indicates that 32-bit integers (Long) are used.
 */
  public static final int SEFLG_JPLEPH = 1;	/* use JPL ephemeris */
  public static final int SEFLG_SWIEPH = 2;	/* use SWISSEPH ephemeris */
  public static final int SEFLG_MOSEPH = 4;	/* use Moshier ephemeris */
  /* return heliocentric position */
  public static final int SEFLG_HELCTR = 8;
  /* return true positions, not apparent */
  public static final int SEFLG_TRUEPOS = 16;
  /* no precession, i.e. give J2000 equinox */
  public static final int SEFLG_J2000 = 32;
  /* no nutation, i.e. mean equinox of date */
  public static final int SEFLG_NONUT = 64;
  /* speed from 3 positions (do not use it,
     SEFLG_SPEED is faster and more precise.) */
  public static final int SEFLG_SPEED3 = 128;
  public static final int SEFLG_SPEED = 256;	/* high precision speed  */
  /* turn off gravitational deflection */
  public static final int SEFLG_NOGDEFL = 512;
  /* turn off 'annual' aberration of light */
  public static final int SEFLG_NOABERR = 1024;
  /* equatorial positions are wanted */
  public static final int SEFLG_EQUATORIAL = (2*1024);
  /* cartesian, not polar, coordinates */
  public static final int SEFLG_XYZ = (4*1024);
  /* coordinates in radians, not degrees */
  public static final int SEFLG_RADIANS = (8*1024);
  /* barycentric positions */
  public static final int SEFLG_BARYCTR = (16*1024);
  /* topocentric positions */
  public static final int SEFLG_TOPOCTR = (32*1024);
  /* sidereal positions */
  public static final int SEFLG_SIDEREAL = (64*1024);

  public static final int SE_SIDBITS = 256;
  /* for projection onto ecliptic of t0 */
  public static final int SE_SIDBIT_ECL_T0 = 256;
  /* for projection onto solar system plane */
  public static final int SE_SIDBIT_SSY_PLANE = 512;

  /* sidereal modes (ayanamsas) */
  public static final int SE_SIDM_FAGAN_BRADLEY = 0;
  public static final int SE_SIDM_LAHIRI = 1;
  public static final int SE_SIDM_DELUCE = 2;
  public static final int SE_SIDM_RAMAN = 3;
  public static final int SE_SIDM_USHASHASHI = 4;
  public static final int SE_SIDM_KRISHNAMURTI = 5;
  public static final int SE_SIDM_DJWHAL_KHUL = 6;
  public static final int SE_SIDM_YUKTESHWAR = 7;
  public static final int SE_SIDM_JN_BHASIN = 8;
  public static final int SE_SIDM_BABYL_KUGLER1 = 9;
  public static final int SE_SIDM_BABYL_KUGLER2 = 10;
  public static final int SE_SIDM_BABYL_KUGLER3 = 11;
  public static final int SE_SIDM_BABYL_HUBER = 12;
  public static final int SE_SIDM_BABYL_ETPSC = 13;
  public static final int SE_SIDM_ALDEBARAN_15TAU = 14;
  public static final int SE_SIDM_HIPPARCHOS = 15;
  public static final int SE_SIDM_SASSANIAN = 16;
  public static final int SE_SIDM_GALCENT_0SAG = 17;
  public static final int SE_SIDM_J2000 = 18;
  public static final int SE_SIDM_J1900 = 19;
  public static final int SE_SIDM_B1950 = 20;
  public static final int SE_SIDM_USER = 255;

  public static final int SE_NSIDM_PREDEF = 21;

  /* used for swe_nod_aps(): */
  public static final int SE_NODBIT_MEAN = 1;	/* mean nodes/apsides */
  public static final int SE_NODBIT_OSCU = 2;	/* osculating nodes/apsides */
  /* same, but motion about solar system barycenter is considered */
  public static final int SE_NODBIT_OSCU_BAR = 4;
  /* focal point of orbit instead of aphelion */
  public static final int SE_NODBIT_FOPOINT = 256;

  /* default ephemeris used when no ephemeris flagbit is set */
  public static final int SEFLG_DEFAULTEPH = SEFLG_SWIEPH;

  /* from sweph.c */
  public static final int SEI_NPLANETS = 18;

  public static final int SEI_NNODE_ETC = 4;

  /* obliquity of ecliptic */
  static class epsilon {
    double teps, eps, seps, ceps; 	/* jd, eps, sin(eps), cos(eps) */
    epsilon() {
      teps = eps = seps = ceps = 0;
    }
    void	calc(double tjd) {
      teps = tjd;
      eps = SwephLib.swi_epsiln(tjd);
      seps = Math.sin(eps);
      ceps = Math.cos(eps);
    }
    void	clear() {
      teps = eps = seps = ceps = 0;
    }
  };

  static class plan_data {
    /* the following data are read from file only once, immediately after 
     * file has been opened */
    int ibdy;		/* internal body number */
    long iflg;		/* contains several bit flags describing the data:
			 * SEI_FLG_HELIO: true if helio, false if bary
			 * SEI_FLG_ROTATE: TRUE if coefficients are referred 
			 *      to coordinate system of orbital plane 
			 * SEI_FLG_ELLIPSE: TRUE if reference ellipse */
    int ncoe;		/* # of coefficients of ephemeris polynomial,
			   is polynomial order + 1  */
    /* where is the segment index on the file */
    long lndx0;   	/* file position of begin of planet's index */
    long nndx;		/* number of index entries on file: computed */
    double tfstart;	/* file contains ephemeris for tfstart thru tfend */
    double tfend;	/*      for this particular planet !!!            */
    double dseg;	/* segment size (days covered by a polynomial)  */
    /* orbital elements: */
    double telem;		/* epoch of elements */
    double prot;		
    double qrot; 
    double dprot;
    double dqrot; 
    double rmax;	/* normalisation factor of cheby coefficients */
    /* in addition, if reference ellipse is used: */
    double peri;		
    double dperi; 
    double refep[];	/* pointer to cheby coeffs of reference ellipse,
			 * size of data is 2 x ncoe */
    /* unpacked segment information, only updated when a segment is read: */
    double tseg0, tseg1;	/* start and end jd of current segment */
    double segp[];	/* pointer to unpacked cheby coeffs of segment;
			 * the size is 3 x ncoe */
    int neval;		/* how many coefficients to evaluate. this may
			 * be less than ncoe */
    /* result of most recent data evaluation for this body: */
    double teval;	/* time for which previous computation was made */
    long iephe;		/* which ephemeris was used */
    double x[];		/* position and speed vectors equatorial J2000 */
    long xflgs;		/* hel., light-time, aberr., prec. flags etc. */
    double xreturn[];	/* return positions:
			 * xreturn+0	ecliptic polar coordinates
			 * xreturn+6	ecliptic cartesian coordinates
			 * xreturn+12	equatorial polar coordinates
			 * xreturn+18	equatorial cartesian coordinates
			 */
    plan_data() {
      ibdy = 0;
      iflg = 0;
      ncoe = 0;
      lndx0 = 0;
      nndx = 0;
      tfstart = 0;
      tfend = 0;
      dseg = 0;
      telem = 0;
      prot = 0;
      qrot = 0;
      dprot = 0;
      dqrot = 0;
      rmax = 0;
      peri = 0;
      dperi = 0;
      refep = null;
      tseg0 = tseg1 = 0;
      segp = null;
      neval = 0;
      teval = 0;
      iephe = 0;
      x = new double[6];
      for (int i = 0; i < 6; i++) {
	x[i] = 0;
      }
      xflgs = 0;
      xreturn = new double[24];
      for (int i = 0; i < 24; i++) {
	xreturn[i] = 0;
      }
    }
    void	clear() {
      ibdy = 0;
      iflg = 0;
      ncoe = 0;
      lndx0 = 0;
      nndx = 0;
      tfstart = 0;
      tfend = 0;
      dseg = 0;
      telem = 0;
      prot = 0;
      qrot = 0;
      dprot = 0;
      dqrot = 0;
      rmax = 0;
      peri = 0;
      dperi = 0;
      refep = null;
      tseg0 = tseg1 = 0;
      segp = null;
      neval = 0;
      teval = 0;
      iephe = 0;
      for (int i = 0; i < 6; i++) {
	x[i] = 0;
      }
      xflgs = 0;
      for (int i = 0; i < 24; i++) {
	xreturn[i] = 0;
      }
    }
  };

  /* nutation */
  static class nut {
    double tnut;
    double nutlo[];	/* nutation in longitude and obliquity */
    double snut, cnut;	/* sine and cosine of nutation in obliquity */
    double matrix[][];
    nut() {
      tnut = 0;
      nutlo = new double[2];
      for (int i = 0; i < 2; i++) {
	nutlo[i] = 0;
      }
      snut = cnut = 0;
      matrix = new double[3][3];
      for (int i = 0; i < 3; i++) {
	matrix[i] = new double[3];
	for (int j = 0; j < 3; j++) {
	  matrix[i][j] = 0;
	}
      }
    }
    void	clear() {
      tnut = 0;
      for (int i = 0; i < 2; i++) {
	nutlo[i] = 0;
      }
      snut = cnut = 0;
      for (int i = 0; i < 3; i++) {
	for (int j = 0; j < 3; j++) {
	  matrix[i][j] = 0;
	}
      }
    }
  };

  static class gen_const {
    double clight, aunit, helgravconst, ratme, sunradius;
    gen_const() {
      clight = aunit = helgravconst = ratme = sunradius = 0;
    }
    void	clear() {
      clight = aunit = helgravconst = ratme = sunradius = 0;
    }
  };

  static class save_positions {
    int ipl;
    double tsave;
    long iflgsave;
    /* position at t = tsave,
     * in ecliptic polar (offset 0),
     *    ecliptic cartesian (offset 6), 
     *    equatorial polar (offset 12),
     *    and equatorial cartesian coordinates (offset 18).
     * 6 doubles each for position and speed coordinates.
     */
    double xsaves[];
    save_positions() {
      ipl = 0;
      tsave = 0;
      iflgsave = 0;
      xsaves = new double[24];
      for (int i = 0; i < 24; i++) {
	xsaves[i] = 0;
      }
    }
    void	clear() {
      ipl = 0;
      tsave = 0;
      iflgsave = 0;
      for (int i = 0; i < 24; i++) {
	xsaves[i] = 0;
      }
    }
  };

  static class topo_data {
    double geolon, geolat, geoalt;
    double teval;
    double tjd_ut;
    double xobs[];
    topo_data() {
      geolon = geolat = geoalt = 0;
      teval = 0;
      tjd_ut = 0;
      xobs = new double[6];
      for (int i = 0; i < 6; i++) {
	xobs[i] = 0;
      }
    }
    void	clear() {
      geolon = geolat = geoalt = 0;
      teval = 0;
      tjd_ut = 0;
      for (int i = 0; i < 6; i++) {
	xobs[i] = 0;
      }
    }
  };

  static class sid_data {
    int	sid_mode;
    double ayan_t0;
    double t0;
    sid_data() {
      sid_mode = 0;
      ayan_t0 = 0;
      t0 = 0;
    }
    void	clear() {
      sid_mode = 0;
      ayan_t0 = 0;
      t0 = 0;
    }
  };

  static class swe_data {
    /* boolean ephe_path_is_set;*/
    /*short jpl_file_is_open;*/
    /* FILE *fixfp;		/* fixed stars file pointer */
    /*String	ephepath;*/
    /*String	jplfnam;*/
    boolean geopos_is_set;
    boolean ayana_is_set;
    /* struct file_data fidat[SEI_NEPHFILES]; */
    gen_const gcdat;
    plan_data pldat[];
    plan_data nddat[];
    save_positions savedat[];
    epsilon oec;
    epsilon oec2000;
    nut nut;
    nut nut2000;
    nut nutv;
    topo_data topd;
    sid_data sidd;
    String	astelem;
    double ast_G;
    double ast_H;
    double ast_diam;
    int i_saved_planet_name;
    String	saved_planet_name;
    swe_data() {
      super();
      geopos_is_set = false;
      ayana_is_set = false;
      gcdat = new gen_const();
      pldat = new plan_data[SEI_NPLANETS];
      for (int i = 0; i < SEI_NPLANETS; i++) {
	pldat[i] = new plan_data();
      }
      nddat = new plan_data[SEI_NNODE_ETC];
      for (int i = 0; i < SEI_NNODE_ETC; i++) {
	nddat[i] = new plan_data();
      }
      savedat = new save_positions[SE_NPLANETS+1];
      for (int i = 0; i <= SE_NPLANETS; i++) {
	savedat[i] = new save_positions();
      }
      oec = new epsilon();
      oec2000 = new epsilon();
      nut = new nut();
      nut2000 = new nut();
      nutv = new nut();
      topd = new topo_data();
      sidd = new sid_data();
      astelem = ""; //$NON-NLS-1$
      ast_G = 0;
      ast_H = 0;
      ast_diam = 0;
      i_saved_planet_name = 0;
      saved_planet_name = ""; //$NON-NLS-1$
    }
    void	clear() {
      geopos_is_set = false;
      ayana_is_set = false;
      for (int i = 0; i < SEI_NPLANETS; i++) {
	pldat[i].clear();
      }
      for (int i = 0; i < SEI_NNODE_ETC; i++) {
	nddat[i].clear();
      }
      for (int i = 0; i <= SEI_NPLANETS; i++) {
	savedat[i].clear();
      }
      oec.clear();
      oec2000.clear();
      nut.clear();
      nut2000.clear();
      nutv.clear();
      topd.clear();
      sidd.clear();
      astelem = ""; //$NON-NLS-1$
      ast_G = 0;
      ast_H = 0;
      ast_diam = 0;
      i_saved_planet_name = 0;
      saved_planet_name = ""; //$NON-NLS-1$
    }
  };

  public swe_data swed = new swe_data();

  public static final int
    SEFLG_EPHMASK = (SEFLG_JPLEPH|SEFLG_SWIEPH|SEFLG_MOSEPH);

  /* maximum size of fixstar name;
   * the parameter star in swe_fixstar
   * must allow twice this space for
   * the returned star name.
   */
  public static final int SE_MAX_STNAME = 20;

  /* defines for eclipse computations */

  public static final int SE_ECL_CENTRAL = 1;
  public static final int SE_ECL_NONCENTRAL = 2;
  public static final int SE_ECL_TOTAL = 4;
  public static final int SE_ECL_ANNULAR = 8;
  public static final int SE_ECL_PARTIAL = 16;
  public static final int SE_ECL_ANNULAR_TOTAL = 32;
  public static final int SE_ECL_PENUMBRAL = 64;
  public static final int SE_ECL_VISIBLE = 128;
  public static final int SE_ECL_MAX_VISIBLE = 256;
  public static final int SE_ECL_1ST_VISIBLE = 512;
  public static final int SE_ECL_2ND_VISIBLE = 1024;
  public static final int SE_ECL_3RD_VISIBLE = 2048;
  public static final int SE_ECL_4TH_VISIBLE = 4096;
  public static final int SE_ECL_ONE_TRY = (32*1024);
  /* check if the next conjunction of the moon with
   * a planet is an occultation; don't search further */

  /* for swe_rise_transit() */
  public static final int SE_CALC_RISE = 1;
  public static final int SE_CALC_SET = 2;
  public static final int SE_CALC_MTRANSIT = 4;
  public static final int SE_CALC_ITRANSIT = 8;
  public static final int SE_BIT_DISC_CENTER = 256;
  /* to be or'ed to SE_CALC_RISE/SET */
  /* if rise or set of disc center is */
  /* requried */
  public static final int SE_BIT_NO_REFRACTION = 512;
  /* to be or'ed to SE_CALC_RISE/SET, */
  /* if refraction is not to be considered */

  /* for swe_azalt() and swe_azalt_rev() */
  public static final int SE_ECL2HOR = 0;
  public static final int SE_EQU2HOR = 1;
  public static final int SE_HOR2ECL = 0;
  public static final int SE_HOR2EQU = 1;

  /* for swe_refrac() */
  public static final int SE_TRUE_TO_APP = 0;
  public static final int SE_APP_TO_TRUE = 1;

  /*
   * only used for experimenting with various JPL ephemeris files
   * which are available at Astrodienst's internal network
   */
  public static final int SE_DE_NUMBER = 406;
  public static final String SE_FNAME_DE200 = "de200.eph"; //$NON-NLS-1$
  public static final String SE_FNAME_DE403 = "de403.eph"; //$NON-NLS-1$
  public static final String SE_FNAME_DE404 = "de404.eph"; //$NON-NLS-1$
  public static final String SE_FNAME_DE405 = "de405.eph"; //$NON-NLS-1$
  public static final String SE_FNAME_DE406 = "de406.eph"; //$NON-NLS-1$
  public static final String SE_FNAME_DFT = SE_FNAME_DE406;
  public static final String SE_STARFILE = "fixstars.cat"; //$NON-NLS-1$
  public static final String SE_ASTNAMFILE = "seasnam.txt"; //$NON-NLS-1$
  public static final String SE_FICTFILE = "seorbel.txt"; //$NON-NLS-1$

/*
 * ephemeris path
 * this defines where ephemeris files are expected if the function
 * swe_set_ephe_path() is not called by the application.
 * Normally, every application should make this call to define its
 * own place for the ephemeris files.
 */

  public static final String SE_EPHE_PATH =
    ".:/users/ephe2/:/users/ephe/:./ephe/"; //$NON-NLS-1$
  /* At Astrodienst, we maintain two ephemeris areas for
     the thousands of asteroid files: 
     the short files in /users/ephe/ast*,
     the long file in /users/ephe2/ast*. */

  /* defines for function swe_split_deg() (in swephlib.c) */
  public static final int SE_SPLIT_DEG_ROUND_SEC = 1;
  public static final int SE_SPLIT_DEG_ROUND_MIN = 2;
  public static final int SE_SPLIT_DEG_ROUND_DEG = 4;
  public static final int SE_SPLIT_DEG_ZODIACAL = 8;
  public static final int SE_SPLIT_DEG_KEEP_SIGN = 16;
  /* don't round to next sign, 
   * e.g. 29.9999999 will be rounded
   * to 2959'59" (or 2959' or 29) */

  public static final int SE_SPLIT_DEG_KEEP_DEG = 32;
  /* don't round to next degree
   * e.g. 13.9999999 will be rounded
   * to 1359'59" (or 1359' or 13) */

  /**************************** 
   * from sweodef.h 
   ****************************/

  /* used for string declarations, allowing 255 char+\0 */
  static final int AS_MAXCH = 256;
  static final double DEGTORAD = 0.0174532925199433;
  static final double RADTODEG = 57.2957795130823;
 
  /**************************** 
   * exports from sweph.h 
   ****************************/

  public static final int MAXORD = 40;

  static final double J2000 = 2451545.0;	/* 2000 January 1.5 */
  static final double B1950 = 2433282.42345905;	/* 1950 January 0.923 */
  static final double J1900 = 2415020.0;	/* 1900 January 0.5 */

  static final int MPC_CERES = 1;
  static final int MPC_PALLAS = 2;
  static final int MPC_JUNO = 3;
  static final int MPC_VESTA = 4;
  static final int MPC_CHIRON = 2060;
  static final int MPC_PHOLUS = 5145;

  static final String SE_NAME_SUN = "Sun"; //$NON-NLS-1$
  static final String SE_NAME_MOON = "Moon"; //$NON-NLS-1$
  static final String SE_NAME_MERCURY = "Mercury"; //$NON-NLS-1$
  static final String SE_NAME_VENUS = "Venus"; //$NON-NLS-1$
  static final String SE_NAME_MARS = "Mars"; //$NON-NLS-1$
  static final String SE_NAME_JUPITER = "Jupiter"; //$NON-NLS-1$
  static final String SE_NAME_SATURN = "Saturn"; //$NON-NLS-1$
  static final String SE_NAME_URANUS = "Uranus"; //$NON-NLS-1$
  static final String SE_NAME_NEPTUNE = "Neptune"; //$NON-NLS-1$
  static final String SE_NAME_PLUTO = "Pluto"; //$NON-NLS-1$
  static final String SE_NAME_MEAN_NODE = "mean Node"; //$NON-NLS-1$
  static final String SE_NAME_TRUE_NODE = "true Node"; //$NON-NLS-1$
  static final String SE_NAME_MEAN_APOG = "mean Apogee"; //$NON-NLS-1$
  static final String SE_NAME_OSCU_APOG = "osc. Apogee"; //$NON-NLS-1$
  static final String SE_NAME_EARTH = "Earth"; //$NON-NLS-1$
  static final String SE_NAME_CERES = "Ceres"; //$NON-NLS-1$
  static final String SE_NAME_PALLAS = "Pallas"; //$NON-NLS-1$
  static final String SE_NAME_JUNO = "Juno"; //$NON-NLS-1$
  static final String SE_NAME_VESTA = "Vesta"; //$NON-NLS-1$
  static final String SE_NAME_CHIRON = "Chiron"; //$NON-NLS-1$
  static final String SE_NAME_PHOLUS = "Pholus"; //$NON-NLS-1$

  static final String SE_NAME_CUPIDO = "Cupido"; //$NON-NLS-1$
  static final String SE_NAME_HADES = "Hades"; //$NON-NLS-1$
  static final String SE_NAME_ZEUS = "Zeus"; //$NON-NLS-1$
  static final String SE_NAME_KRONOS = "Kronos"; //$NON-NLS-1$
  static final String SE_NAME_APOLLON = "Apollon"; //$NON-NLS-1$
  static final String SE_NAME_ADMETOS = "Admetos"; //$NON-NLS-1$
  static final String SE_NAME_VULKANUS = "Vulkanus"; //$NON-NLS-1$
  static final String SE_NAME_POSEIDON = "Poseidon"; //$NON-NLS-1$
  static final String SE_NAME_ISIS = "Isis"; //$NON-NLS-1$
  static final String SE_NAME_NIBIRU = "Nibiru"; //$NON-NLS-1$
  static final String SE_NAME_HARRINGTON = "Harrington"; //$NON-NLS-1$
  static final String SE_NAME_NEPTUNE_LEVERRIER = "Leverrier"; //$NON-NLS-1$
  static final String SE_NAME_NEPTUNE_ADAMS = "Adams"; //$NON-NLS-1$
  static final String SE_NAME_PLUTO_LOWELL = "Lowell"; //$NON-NLS-1$
  static final String SE_NAME_PLUTO_PICKERING = "Pickering"; //$NON-NLS-1$
  static final String SE_NAME_VULCAN = "Vulcan"; //$NON-NLS-1$
  static final String SE_NAME_WHITE_MOON = "White Moon"; //$NON-NLS-1$

  /* for delta t: tidal acceleration in the mean motion of the moon */
  static final double SE_TIDAL_DE403 = (-25.8);
  static final double SE_TIDAL_DE404 = (-25.8);
  static final double SE_TIDAL_DE405 = (-25.7376);
  static final double SE_TIDAL_DE406 = (-25.7376);
  static final double SE_TIDAL_DE200 = (-23.8946);
  static final double SE_TIDAL_26 = (-26.0);

  static final double SE_TIDAL_DEFAULT = SE_TIDAL_DE406;

  /**
   * constant <code>NCTIES</code> is the number of centuries per eph. file.
   */
  public static final double NCTIES = 6.0;

  public static final int OK = (0);
  public static final int ERR = (-1);
  public static final int NOT_AVAILABLE = (-2);
  public static final int BEYOND_EPH_LIMITS = (-3);

  public static final int J_TO_J2000 = 1;
  public static final int J2000_TO_J = -1;
  
/* node of ecliptic measured on ecliptic 2000 */
  public static final double SSY_PLANE_NODE_E2000 = (107.582569 * DEGTORAD);
/* node of ecliptic measured on solar system rotation plane */
  public static final double SSY_PLANE_NODE = (107.58883388 * DEGTORAD);
/* inclination of ecliptic against solar system rotation plane */
  public static final double SSY_PLANE_INCL = (1.578701 * DEGTORAD);

  static final double square_sum(double x[], int xIndex) {
    return(x[xIndex+0]*x[xIndex+0] + x[xIndex+1]*x[xIndex+1]
	   + x[xIndex+2]*x[xIndex+2]);
  }

  static final double dot_prod(double x[], int xIndex,
			       double y[], int yIndex) {
    return(x[xIndex+0]*y[yIndex+0] + x[xIndex+1]*y[yIndex+1]
	   + x[xIndex+2]*y[yIndex+2]);
  }

  /**************************** 
   * exports from sweph.c 
   ****************************/

  /* planets, moon, nodes etc. */
  public abstract int
    swe_calc(double tjd, int ipl, int iflag, double xx[], String serr);

  public abstract int
    swe_calc_ut(double tjd_ut, int ipl, int iflag, double xx[], String serr);

  /* fixed stars */
  public abstract int
    swe_fixstar(String star, double tjd, int iflag, double xx[], String serr);

  public abstract int
    swe_fixstar_ut(String star, double tjd, int iflag,
		   double xx[], String serr);

  /* close Swiss Ephemeris */
  public abstract void swe_close();

  /* set directory path of ephemeris files */
  public abstract void swe_set_ephe_path(String path);

  /* set file name of JPL file */
  public abstract void swe_set_jpl_file(String fname);

  /* get planet name */
  public abstract String swe_get_planet_name(int ipl, String spname);

  /* set geographic position of observer */
  public abstract void
    swe_set_topo(double geolon, double geolat, double geoalt);

  /* set sidereal mode */
  public abstract void
    swe_set_sid_mode(int sid_mode, double t0, double ayan_t0);

  /* get ayanamsa */
  public abstract double swe_get_ayanamsa(double tjd_et);

  public abstract double swe_get_ayanamsa_ut(double tjd_ut);

  public abstract String swe_get_ayanamsa_name(int isidmode);



}
