/* $Id: AbstractGSWindow.java 535 2012-08-21 04:55:59Z shayashi $ */
package smart_gs.swingui;


import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JFrame;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSTabbedPane;

/**
 * 
 * @author kazuaki kobayashi
 *
 * 
 */
public abstract class AbstractGSWindow extends JFrame implements GSEditorFrame{
	
	protected GSTabbedPane tabbedPane;
	private static final Image icon = new ImageIcon("./icons/SGS_icon.gif").getImage();
	
	public AbstractGSWindow(String title){
		super(title);
		this.setIconImage(icon);
	}
	
	public abstract GSTabbedPane createTabbedPane(Spread spread);
	
	public GSTabbedPane getTabbedPane() {
		return this.tabbedPane;
	}
	
	public void close(){
		this.tabbedPane.clear();
	}
	
	public abstract void setSpread(Spread spread);
	public abstract Spread getSpread();
	public abstract void updateGUI(Spread spread);
	
	public abstract SpreadCanvas getSpreadCanvas();
	public abstract void setMode(Mode mode);
	

	
}
