/* $Id: SelectionListCheckBoxSelector.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.spread_selection;

import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.tree.DefaultMutableTreeNode;

public class SelectionListCheckBoxSelector {
	
	ArrayList<Integer> selectionList = new ArrayList();
	DefaultMutableTreeNode rootNode;
	
	public SelectionListCheckBoxSelector(DefaultMutableTreeNode givenRootNode) {
		super();
		rootNode = givenRootNode;
	}

	public void select(String selectionList) {
		selectCheckBoxOfSelectionList(rootNode, selectionList);
	}
	//	Select all the JCheckBox'es by selectionList AND under the node.
	private void selectCheckBoxOfSelectionList (DefaultMutableTreeNode node, String selectionList) {
		Enumeration<DefaultMutableTreeNode> enumeration = node.depthFirstEnumeration();
		SelectionListMembershipChecker membershipChecker = new SelectionListMembershipChecker(selectionList);
		while (enumeration.hasMoreElements()) {
			Object usrObj = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
			if (usrObj instanceof CheckBoxNode) {
				CheckBoxNode cbnode = ((CheckBoxNode) usrObj);
				int index = cbnode.getIndex();
				if (membershipChecker.isIn(index)) {
					cbnode.setSelected(true);
				} else {
					cbnode.setSelected(false);
				}
			}
		}
	}
}