/* $Id: SaveSpreadSelectionListAction.java 343 2011-09-07 14:39:45Z shayashi $ */
package smart_gs.spread_selection;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JOptionPane;
import javax.swing.JTextField;

import smart_gs.logical.SpreadSelectionList;
import smart_gs.logical.SpreadSelectionListManager;

class SaveSpreadSelectionListAction implements ActionListener {
	String newSpreadSelectionListName;
	JTextField newSpreadSelectionListSpecPanel;
	String newSpreadSelectionListSpec;
	SetScopePanel callingSetScopePanel;

	public SaveSpreadSelectionListAction (SetScopePanel setScopePanel) {
		this.callingSetScopePanel = setScopePanel;
		this.newSpreadSelectionListSpecPanel = this.callingSetScopePanel.getPageSelectField();
		}
	
	public void actionPerformed(ActionEvent e) {
//		added shayashi 2010/11/05
		newSpreadSelectionListSpec = newSpreadSelectionListSpecPanel.getText();
		if (!(new SpreadSelectionListGrammarChecker()).checks(newSpreadSelectionListSpec)) {
			JOptionPane.showMessageDialog(callingSetScopePanel, newSpreadSelectionListSpec + ": ill-formed selection list", "Error", JOptionPane.ERROR_MESSAGE);			
			return;	
		}
		
		newSpreadSelectionListName = JOptionPane.showInputDialog(callingSetScopePanel,"Input SpreadSelectionList name",newSpreadSelectionListName);
		if (newSpreadSelectionListName !=null){
			if (!(new SpreadSelectionListIdentifierGrammarChecker()).checks(newSpreadSelectionListName)){
				JOptionPane.showMessageDialog(callingSetScopePanel,"name must be an non-empty string of 0-9,A-z,_-+=.&~:,Japanese zenkaku-moji starting with A-z or Japanese zenkaku-moji","",JOptionPane.PLAIN_MESSAGE);
				return;
			}
			SpreadSelectionListManager.getInstance().addSpreadSelectionList(newSpreadSelectionListName,newSpreadSelectionListSpec);
		}
	}

}
