/* $Id: GSTreeTextEditortPaneManager.java 603 2012-11-08 14:18:45Z ohura $ */
package smart_gs.smleditor.swingui;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

import smart_gs.logical.SmartDocument;
import smart_gs.swingui.GSTabbedPaneManagerContainer;


public class GSTreeTextEditortPaneManager {
	protected static HashMap<String, GSTreeTextEditortPaneManagerContainer> gsTreeTextEditorMap = new HashMap<String,  GSTreeTextEditortPaneManagerContainer>();
	protected static HashMap<String, String> windowMap = new HashMap<String,  String>();
	protected static AtomicLong id = new AtomicLong();

	public static void setGSTreeTextEditort(String key,String windowid,GSTreeTextEditor gsTreeTextEditor){
		synchronized (gsTreeTextEditorMap) {
			GSTreeTextEditortPaneManagerContainer gsTreeTextEditortPaneManagerContainer = new GSTreeTextEditortPaneManagerContainer(key,windowid,gsTreeTextEditor);
			gsTreeTextEditorMap.put(key, gsTreeTextEditortPaneManagerContainer);
			if(!windowMap.containsKey(windowid)){
				windowMap.put(windowid,key);
			}

		}
	}
	public static void removeGSTreeTextEditort(String key){
		synchronized (gsTreeTextEditorMap) {
			gsTreeTextEditorMap.remove(key);
		}
	}
	public static GSTreeTextEditor getGSTreeTextEditort(String key){
		GSTreeTextEditortPaneManagerContainer gsTreeTextEditortPaneManagerContainer = gsTreeTextEditorMap.get(key);
		if(gsTreeTextEditortPaneManagerContainer == null){
			return null;
		}
		return gsTreeTextEditortPaneManagerContainer.getGsTreeTextEditor();
	}
	
	public static String getWindowsID(String key){
		GSTreeTextEditortPaneManagerContainer gsTreeTextEditortPaneManagerContainer = gsTreeTextEditorMap.get(key);
		if(gsTreeTextEditortPaneManagerContainer == null){
			return null;
		}
		return gsTreeTextEditortPaneManagerContainer.getWindowid();
	}

	public static long getControlid(){
		return id.incrementAndGet();
	}

	public static void close(String windowid){
		synchronized (gsTreeTextEditorMap) {
			String key = windowMap.get(windowid);
			windowMap.remove(windowid);
			// JĂWindow݂Ȃ
			if(!windowMap.containsValue(key)){
				synchronized (gsTreeTextEditorMap) {
					gsTreeTextEditorMap.remove(key);
				}
			}
		}
	}

}
