package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Hashtable;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;

import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectContentTreePanel extends JPanel {
	
	private HCPProject project;
	private ProjectTree tree;
	
	public ProjectContentTreePanel() {
		JLabel label = new JLabel();
		this.add(label);
	}
	
	public ProjectContentTreePanel(HCPProject project, String location) {
		this();
		JLabel label = ProjectContentTreePanel.getLabel(location);
		this.project = project;
		this.tree = new ProjectTree(this.project, location);
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		JScrollPane sPane = new JScrollPane(tree);
		this.add(label);
		this.add(sPane);
		this.updateUI();	}

	public void reset(HCPProject project, String location) {
		this.removeAll();
		JLabel label = getLabel(location);
		this.project = project;
		this.tree = new ProjectTree(this.project, location);
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		JScrollPane sPane = new JScrollPane(tree);
		this.add(label);
		this.add(sPane);
		this.updateUI();
	}

	private static JLabel getLabel(String location) {
		JLabel label = new JLabel();
		label.setText(location.toUpperCase());
		label.setSize(new Dimension(Short.MAX_VALUE, label.getFontMetrics(label.getFont()).getHeight()));
		label.setBackground(Color.GRAY);
		return label;
	}

	public ProjectTree getProjectTree() {
		return this.tree;
		
	}

}
