package smart_gs.menu.action;

import java.awt.Point;
import java.awt.Rectangle;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.swingui.WorkspaceWindow;

public class SpreadJumpAction {
	
	public static void jump(Spread spread) {
		WorkspaceWindow.getInstance().setSpread(spread);
		WorkspaceWindow.getInstance().setImageSearch(spread.toString());
		SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
		canvas.imageLabel.showImage();
	}

	public static void jumpToMarkup(Region region) {
		Spread spread = region.getSpread();
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		if (window.getSpread() == null || 
				(window.getSpread() != null && !window.getSpread().equals(spread))) {
			window.setSpread(spread);
			window.setImageSearch(spread.toString());
		}
		SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
		canvas.imageLabel.showImage();
		canvas.imageLabel.moveTo((region).getCornerPoint());
		ImageLabel.setState(UniSelectedState.getInstance());
		canvas.selectRegion(region);		
	}
	
	public static void jumpToTempRectangleRegion(RectangleRegion rectreg) {
		Rectangle rect = rectreg.getRectangle();
		Spread spread = rectreg.getSpread();
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		if (window.getSpread() == null || 
				(window.getSpread() != null && !window.getSpread().equals(spread))) {
			window.setSpread(spread);
			window.setImageSearch(spread.toString());
		}
		SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
		canvas.imageLabel.moveTo((rectreg).getCornerPoint());
		View view = new RectangleView(rect);
		view.setIsEmphasized(true);
		canvas.addTempView(view);
		ImageLabel.setState(UniSelectedState.getInstance());
		canvas.selectRegion(rectreg);
		canvas.imageLabel.showImage();
	}

	public static void jumpToMarkup(TextSegment segment) {
		SmartDocument doc = segment.getDocument();
		if (!doc.isIDAT()) {
			return;
		}
		IDAT idat = (IDAT)doc;
		Spread spread = idat.getSpread();
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		if (window.getSpread() == null || 
				(window.getSpread() != null && !window.getSpread().equals(spread))) {
			window.setSpread(spread);
			window.setImageSearch(spread.toString());
		}
		SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
		canvas.imageLabel.showImage();
		WorkspaceWindow.getInstance().getTabbedPane().emphasize(segment);
	}

}
