package smart_gs.menu.action;

import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.WorkspaceWindow;

public class DefaultFileTypeSwitchChangeListener implements ChangeListener {

	private JRadioButton gsxSwitch;
	private JRadioButton hcpSwitch;
	private JButton gsxReference;
	private JButton hcpReference;

	public DefaultFileTypeSwitchChangeListener(JRadioButton gsxButton,
			JRadioButton hcpButton, JButton gsxReference,
			JButton hcpReference) {
		this.gsxSwitch = gsxButton;
		this.hcpSwitch = hcpButton;
		this.gsxReference = gsxReference;
		this.hcpReference = hcpReference;

	}

	@Override
	public void stateChanged(ChangeEvent e) {
		Debugprint.from();
		Debugprint.message("state changed.");
		if (gsxSwitch.isSelected()) {
			Debugprint.message("GSX file is selected");
			this.gsxReference.setEnabled(true);
			this.hcpReference.setEnabled(false);
		} else if (hcpReference.isSelected()) {
			Debugprint.message("HCP Project is selected");
			this.gsxReference.setEnabled(false);
			this.hcpReference.setEnabled(true);
		}
		WorkspaceWindow.getInstance().repaint();
	}

}
