/* $Id: GSMenuBar.java 602 2012-10-11 18:54:42Z minao $ */
package smart_gs.menu;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;
import smart_gs.network.RepositoryMenu;

@SuppressWarnings("serial")
public class GSMenuBar extends JMenuBar{
	private EditMenu editMenu;
	private GSEditorTextPane textPane;
	private JMenu fileMenu;

	//2007/11/1 kazuhiro kobayashi
	public GSMenuBar(AbstractGSWindow parent,GSEditorToolBar gsEditorToolBar){
		this.fileMenu = new FileMenu("File");
		this.add(fileMenu);
		this.editMenu = new EditMenu("Edit", this.textPane,gsEditorToolBar);
		this.add(editMenu);
		JMenu toolMenu = new ToolMenu("Tool", parent);		
		this.add(toolMenu);
		JMenu searchMenu = new SearchMenu("Search", parent);		
		this.add(searchMenu);
		JMenu reasoningWebMenu = new ReasoningWebMenu("RW", parent);
		this.add(reasoningWebMenu);
		JMenu connectionMenu = new ConnectionMenu("Connection", parent);		
		this.add(connectionMenu);
		JMenu repositoryMenu = new RepositoryMenu("Repository", parent);		
		this.add(repositoryMenu);

		
		JMenu preferenceMenu = new PreferenceMenu("Preference", parent);		
		this.add(preferenceMenu);
//		JMenu sheetMenu = new SheetMenu("Sheet");
//		this.add(sheetMenu);
	}
	public void setEditorTextPane(EditorTextPane textPane){
		this.editMenu.setTextPane(textPane);
		this.validate();
	}
	public void setEnabledSaveMenu(boolean enabled){
//		this.fileMenu.
	}
	
}
