/* $Id: DirectorySettingWindow.java 720 2013-08-05 02:53:51Z minao $ */
package smart_gs.menu;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import smart_gs.SmartGS;
import smart_gs.logical.Preference;
import smart_gs.menu.action.DefaultFileTypeSwitchChangeListener;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetDefaultHCPProjectAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetRWBackgroundFilePathAction;
import smart_gs.menu.action.SetWorkspaceDirectoryPathAction;
import smart_gs.swingui.ButtonFrame;
import smart_gs.util.GSImageFileUtils;
import smart_gs.util.GSPathStringGrammarChecker;

/**
 * etH_̃pXݒ肷EBhE
 * 
 * @author kaszuhiro kobayashi
 * 
 */
@SuppressWarnings("serial")
public class DirectorySettingWindow extends ButtonFrame implements
		ActionListener {

	private JPanel directorySettingPanel;

	private JTextField smart_gsTextField;

	private JPanel gsFolderPanel;
	private JTextField gsTextField;

	private JPanel imageFolderPanel;
	private JTextField imageTextField;	

	private JPanel dscFolderPanel;
	private JTextField dscTextField;	
	

	// 2007/12/8 kazuhiro kobayashi
	private JPanel RWBackgroundFilePanel;
	private JTextField RWBackgroundFileTextField;

	private JPanel workspaceDirectoryPanel;
	private JTextField workspaceDirectoryTextField;

	private JPanel defaultFilePanel;
	private JPanel defaultGSXFilePanel;
	private JTextField defaultGSXFileTextField;
	private JPanel defaultHCPProjectPanel;
	private JTextField defaultHCPProjectTextField;

	
	private static DirectorySettingWindow singleton = new DirectorySettingWindow();

	public static DirectorySettingWindow getInstance() {
		return singleton;
	}

	public DirectorySettingWindow() {
		super("Data Directories & Files Setting");

		this.setAlwaysOnTop(true);
		this.setResizable(false);

//		shaysahi 2011.05.25
		if (SmartGS.isDscFolderSetting()) {
			this.directorySettingPanel = new JPanel(new GridLayout(5, 1));
		} else {
			this.directorySettingPanel = new JPanel(new GridLayout(4, 1));
		}
		
		this.gsFolderPanel = new JPanel(new FlowLayout());
		this.gsFolderPanel.setBorder(new TitledBorder("GS Files"));
		this.gsTextField = new JTextField(20);
		this.gsTextField.setText(Preference.getInstance().getGsFolderPathString());
		JButton gsReferenceButton = new JButton("Select ...");
		SetCurrentDirectoryAction gsAction = new SetCurrentDirectoryAction();
		gsReferenceButton.addActionListener(gsAction);
		this.gsFolderPanel.add(gsTextField);
		this.gsFolderPanel.add(gsReferenceButton);

		this.imageFolderPanel = new JPanel(new FlowLayout());
		this.imageFolderPanel.setBorder(new TitledBorder("Images"));
		this.imageTextField = new JTextField(20);
		this.imageTextField.setText(Preference.getInstance()
				.getImageFolderPathString());
		JButton imageReferenceButton = new JButton("Select ...");
		SetImageFolderPathAction imageAction = new SetImageFolderPathAction();
		imageReferenceButton.addActionListener(imageAction);
		this.imageFolderPanel.add(imageTextField);
		this.imageFolderPanel.add(imageReferenceButton);
		
		// This is optional.
		if (SmartGS.isDscFolderSetting()) {
			this.dscFolderPanel = new JPanel(new FlowLayout());
			this.dscFolderPanel.setBorder(new TitledBorder("DSC Folder"));
			this.dscTextField = new JTextField(20);
			this.dscTextField.setText(Preference.getInstance()
					.getDscFolderPathString());
			JButton dscReferenceButton = new JButton("Select ...");
			SetDscFolderPathAction dscAction = new SetDscFolderPathAction();
			dscReferenceButton.addActionListener(dscAction);
			this.dscFolderPanel.add(dscTextField);
			this.dscFolderPanel.add(dscReferenceButton);
		}
		
		this.defaultFilePanel = new JPanel(new GridLayout(4,1));
		this.defaultFilePanel.setBorder(new TitledBorder("Default GS File"));
		
		String preferredFileType = Preference.getInstance().getFileType();
		boolean gsxIsPreferred = preferredFileType.equals(Preference.GSX);
		boolean hcpIsPreferred = preferredFileType.equals(Preference.HCPProject);
		ButtonGroup fileType = new ButtonGroup();
		JRadioButton gsxButton = new JRadioButton("GSX File", gsxIsPreferred);
		JRadioButton hcpButton = new JRadioButton("HCP Project", hcpIsPreferred);
		fileType.add(gsxButton);
		fileType.add(hcpButton);
		
		this.defaultGSXFilePanel = new JPanel(new FlowLayout());
		this.defaultGSXFileTextField = new JTextField(20);
		this.defaultGSXFileTextField.setText(Preference.getInstance()
				.getDefaultGsFilePathString());
		JButton defaultGSXFileReferenceButton = new JButton("Select ...");
		defaultGSXFileReferenceButton.setEnabled(gsxIsPreferred);
		SetDefaultGsFileAction defaultGSXFileAction = new SetDefaultGsFileAction();
		defaultGSXFileReferenceButton.addActionListener(defaultGSXFileAction);
		this.defaultGSXFilePanel.add(this.defaultGSXFileTextField);
		this.defaultGSXFilePanel.add(defaultGSXFileReferenceButton);

		this.defaultHCPProjectPanel = new JPanel(new FlowLayout());
		this.defaultHCPProjectTextField = new JTextField(20);
		this.defaultHCPProjectTextField.setText(Preference.getInstance()
				.getDefaultHCPProjectNameString());
		JButton defaultHCPProjectReferenceButton = new JButton("Select ...");
		defaultHCPProjectReferenceButton.setEnabled(hcpIsPreferred);
		SetDefaultHCPProjectAction defaultHCPProjectAction = new SetDefaultHCPProjectAction();
		defaultGSXFileReferenceButton.addActionListener(defaultHCPProjectAction);
		this.defaultHCPProjectPanel.add(this.defaultHCPProjectTextField);
		this.defaultHCPProjectPanel.add(defaultHCPProjectReferenceButton);

		gsxButton.addChangeListener(new DefaultFileTypeSwitchChangeListener(gsxButton, hcpButton, defaultGSXFileReferenceButton, defaultHCPProjectReferenceButton));
		hcpButton.addChangeListener(new DefaultFileTypeSwitchChangeListener(gsxButton, hcpButton, defaultGSXFileReferenceButton, defaultHCPProjectReferenceButton));
		this.defaultFilePanel.add(gsxButton);
		this.defaultFilePanel.add(this.defaultGSXFilePanel);		
		this.defaultFilePanel.add(hcpButton);
		this.defaultFilePanel.add(this.defaultHCPProjectPanel);
		
		
		
		
		this.RWBackgroundFilePanel = new JPanel(new FlowLayout());
		this.RWBackgroundFilePanel.setBorder(new TitledBorder(
				"RW Background File"));
		this.RWBackgroundFileTextField = new JTextField(20);
		this.RWBackgroundFileTextField.setText(Preference.getInstance()
				.getRWBackgroundFilePathString());
		JButton RWBackgroundFileReferenceButton = new JButton("Select ...");
		SetRWBackgroundFilePathAction RWBackgroundFileAction = new SetRWBackgroundFilePathAction();
		RWBackgroundFileReferenceButton
				.addActionListener(RWBackgroundFileAction);
		this.RWBackgroundFilePanel.add(this.RWBackgroundFileTextField);
		this.RWBackgroundFilePanel.add(RWBackgroundFileReferenceButton);

		this.workspaceDirectoryPanel = new JPanel(new FlowLayout());
		this.workspaceDirectoryPanel.setBorder(new TitledBorder(
				"Workspace Directory"));
		this.workspaceDirectoryTextField = new JTextField(20);
		this.workspaceDirectoryTextField.setText(Preference.getInstance()
				.getWorkspaceDirectory());
		JButton workspaceDirectoryReferenceButton = new JButton("Select ...");
		SetWorkspaceDirectoryPathAction workspaceDirectoryAction = new SetWorkspaceDirectoryPathAction();
		workspaceDirectoryReferenceButton
				.addActionListener(workspaceDirectoryAction);
		this.workspaceDirectoryPanel.add(this.workspaceDirectoryTextField);
		this.workspaceDirectoryPanel.add(workspaceDirectoryReferenceButton);

		this.directorySettingPanel.add(this.gsFolderPanel);
		this.directorySettingPanel.add(this.imageFolderPanel);
		if (SmartGS.isDscFolderSetting()) {
			this.directorySettingPanel.add(this.dscFolderPanel);
		}
		this.directorySettingPanel.add(this.defaultFilePanel);

		this.directorySettingPanel.add(this.RWBackgroundFilePanel);

		this.directorySettingPanel.add(this.workspaceDirectoryPanel);

		this.getContentPane().add(directorySettingPanel, BorderLayout.CENTER);
		this.pack();

	}

	/**
	 * smart_gsFolderPathݒ肷ƁAnameCorrespondence
	 * ̃tH_̃pXsmart_gsFolderPath̉ɎIɐݒ肷
	 * 
	 * @param path
	 */
	public void setSmart_gsTextField(String path) {
		this.smart_gsTextField.setText(path);
		if (!path.endsWith("/")) path = path + "/";
		this.setGsTextField(path + "gs/");
		this.setImageTextField(path + "images/");
	}

	public void setGsTextField(String path) {
		this.gsTextField.setText(path);
	}

	public void setImageTextField(String path) {
		this.imageTextField.setText(path);
	}
	
	public void setDscTextField(String path) {
		this.dscTextField.setText(path);
	}

	public void setDefaultGsFileField(String path) {
		this.defaultGSXFileTextField.setText(path);
	}

	public void setRWBackgroundFileField(String path) {
		this.RWBackgroundFileTextField.setText(path);
	}
	
	public void setWorkspaceTextField(String path) {
		this.workspaceDirectoryTextField.setText(path);
	}


	public void ok() {
		boolean gsFilesCondition = false;
		boolean imagesCondtion = false;
		boolean dscCondtion = false;
		boolean defaultGsFileCondition = false;
		boolean rWBackgroundFileCondition = false;
		boolean workspaceDirectoryCondition = false;
		
		String gsFilesPathString = this.gsTextField.getText();
		String imagesPathString = this.imageTextField.getText();
		if (dscTextField == null) dscTextField =imageTextField;
		String dscPathString = this.dscTextField.getText();
		String defaultGsFilePathString = this.defaultGSXFileTextField.getText();
		String rWBackgroundFilePathString = this.RWBackgroundFileTextField.getText();
		String workspaceDirectoryPathString = this.workspaceDirectoryTextField.getText();
		
		gsFilesCondition = GSPathStringGrammarChecker.isGsPath(gsFilesPathString);
		imagesCondtion = GSPathStringGrammarChecker.isGsPath(imagesPathString);
		dscCondtion = GSPathStringGrammarChecker.isGsPath(dscPathString);
		defaultGsFileCondition = GSPathStringGrammarChecker.isGsPath(defaultGsFilePathString) || defaultGsFilePathString.equals("");
		rWBackgroundFileCondition = GSPathStringGrammarChecker.isGsPath(rWBackgroundFilePathString) || rWBackgroundFilePathString.isEmpty();
		workspaceDirectoryCondition = GSPathStringGrammarChecker.isGsPath(workspaceDirectoryPathString);
		
		String errorMessage = "";
		String warningMessage = "";
		
		if (gsFilesCondition == false) {
			errorMessage += "GS Files Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(gsFilesPathString)) {
				warningMessage += "GS Files Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(gsFilesPathString)) {
				warningMessage += "GS Files Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (imagesCondtion == false) {
			errorMessage += "Images Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(imagesPathString)) {
				warningMessage += "Images Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(imagesPathString)) {
				warningMessage += "Images Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (dscCondtion == false) {
			errorMessage += "DSC Folder Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(dscPathString)) {
				warningMessage += "DSC Folder Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(dscPathString)) {
				warningMessage += "DSC Folder Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (defaultGsFileCondition == false) {
			errorMessage += "Default GS File Path Error: not fit to the GS file path grammar.\n";
		} else if (GSPathStringGrammarChecker.confusingSeparators(defaultGsFilePathString)) {
			warningMessage += "Default GS File Path Warnig: both of \\ and / present.\n";
		}
		
		if (!(defaultGsFilePathString.endsWith(".gs")
				|| defaultGsFilePathString.endsWith(".gsx")
				|| defaultGsFilePathString.equals(""))) {
			errorMessage += "Default GS File Name Error: must ends with \".gs\" or \".gsx\".\n";
		}
	
		if (rWBackgroundFileCondition == false) {
			errorMessage += "RW Backgroundfile Path Error: not fit to the GS file path grammar.\n";
		} else if (! rWBackgroundFilePathString.isEmpty() && GSPathStringGrammarChecker.confusingSeparators(rWBackgroundFilePathString)) {
			warningMessage += "RW Backgroundfile Path Warnig: both of \\ and / present.\n";
		}
		
		if (! rWBackgroundFilePathString.isEmpty() && ! GSImageFileUtils.isAcceptable(rWBackgroundFilePathString)) {
			errorMessage += "RW Backgroundfile Name Error: must ends with one of " 
				+  GSImageFileUtils.getDescription() + ".\n";
		}

		if (workspaceDirectoryCondition == false) {
			errorMessage += "Workspace Directory Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(workspaceDirectoryPathString)) {
				warningMessage += "Workspace Directory Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(imagesPathString)) {
				warningMessage += "Workspace Directory Path Warnig: it ends not with a separator.\n";
			}
		}
		

		if (!errorMessage.isEmpty()) {
			JOptionPane.showMessageDialog(null,
					errorMessage + warningMessage, "message",
					JOptionPane.INFORMATION_MESSAGE);
			return;
		} else {
			Preference.getInstance().setGsFolderPathString(gsFilesPathString);
			Preference.getInstance().setImageFolderPathString(imagesPathString);
			Preference.getInstance().setDscFolderPathString(dscPathString);
			Preference.getInstance().setDefaultGsFilePath(defaultGsFilePathString);
			Preference.getInstance().setRWBackgroundFilePathString(rWBackgroundFilePathString);
			Preference.getInstance().setWorkspaceDirectory(workspaceDirectoryPathString);
			JOptionPane.showMessageDialog(null,
					"Pathes are set.\n" + "Reboot SMAR-GS to validate path settings.\n" + warningMessage, "message",
					JOptionPane.INFORMATION_MESSAGE);
		};
		this.dispose();
	}

	public void cancel() {
		this.dispose();
	}


	class GsFileNameFormatException extends Exception {
		public GsFileNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane
					.showConfirmDialog(null, "GsFile must has extension \".gs or .gsx\"",
							"error", JOptionPane.OK_OPTION,
							JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

	class RWBackgroundNameFormatException extends Exception {
		public RWBackgroundNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane.showConfirmDialog(null,
					"RWBackground must be image file", "error",
					JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

}
