package smart_gs.logical.region;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import smart_gs.drawing_tool.view.CloseUpRectangleView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class CloseUpRectangleRegion extends Region {
	
	public CloseUpRectangleRegion(Spread spread, Rectangle2D rectangle) {
		super(spread,new CloseUpRectangleView(rectangle));
		double minx = rectangle.getMinX();
		double miny = rectangle.getMinY();
		double maxx = rectangle.getMaxX();
		double maxy = rectangle.getMaxY();
		Point2D a = new Point2D.Double(minx,miny);
		Point2D b = new Point2D.Double(maxx,miny);
		Point2D c = new Point2D.Double(maxx,maxy);
		Point2D d = new Point2D.Double(minx,maxy);
		
		ArrayList<Point2D> list = new ArrayList<Point2D>();
		list.add(a);
		list.add(b);
		list.add(c);
		list.add(d);
		this.points = list;
	}

	public CloseUpRectangleRegion(Spread spread, View view) {
		super(spread, view);
	}
}
