/* $Id: XML2ResourceConverter.java 376 2011-10-02 13:19:27Z shayashi $ */
package smart_gs.logical;

import java.awt.List;
import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.view.AnchorView;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.PolygonView;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.util.GSStandardPath;


public class XML2ResourceConverter {
	
	public static GSResource convert(Element element){
		String tagname = element.getNodeName();
		
		if(tagname.equals("standardDocument")){
			return getStandardDocument(element);
		//1028 shimizu wrote;
		}else if(tagname.equals(URICreator.USERS_NOTE)){
			return getUsersNote(element);
		}else{
			String uri = element.getAttribute("uri");
			return URISolver.getRegion(uri);
		}
	}
	
	public static Region getRegion(Spread spread,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		
		//kazuhiro kobayashi 10/7
		String  protection = element.getAttribute("protection");
		
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("view")){
					String type = elem.getAttribute("type");
					View view = null;
					if(type.equals(URICreator.RECTANGLE)){
						view = RectangleView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals(URICreator.MARKER)){
						view = MarkerView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals(URICreator.LINE)){
						view = LineView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals(URICreator.POLYGON)){
						//shayashi 2011/01/02 lasso-type is readable for upper compatibility
						view = PolygonView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals(URICreator.MEMOPAD)){
						view = MemoPadView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					} else if(type.equals(URICreator.BOOKMARK)){
						view = BookmarkView.restore(elem);
						Region region = new BookmarkRegion(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					} else if(type.equals(URICreator.ANCHOR)){
						view = AnchorView.restore(elem);
						Region region = new AnchorRegion(spread,view,uri,originalURI,version);
						region.setOldVersionURI(oldVersionURI);
						region.setName(name);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}
				}
				
			}
		}
		return null;
	}
	
	public static IDAT getIDAT(Spread spread, Element element){
		String type = element.getAttribute("type");
		String source = element.getAttribute("source");

		if(!source.startsWith("<xml><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(source);
				source = convertGS.parser();
				if(source.equals("")){
					source = "<xml><html></html></xml>";
				}else{
					source = "<xml><html>" + source + "</html></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}

		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);

		IDAT doc = null;
		if(type.equals(GSConstants.FIRSTIDAT+"")){
			doc = new FirstIDAT(spread,uri,originalURI,version);
		}else if(type.equals(GSConstants.SECONDIDAT+"")){
		    doc = new SecondIDAT(spread,uri,originalURI,version);
		}else if(type.equals(GSConstants.THIRDIDAT+"")){
			doc = new ThirdIDAT(spread,uri,originalURI,version);

		}
		doc.setOldVersionURI(oldVersionURI);
//		2011.06.11 shayashi changed
		doc.setSource(source);
		NodeList list = element.getElementsByTagName(URICreator.TEXT_SEGMENT);
		for(int i=0;i<list.getLength();i++){
			Element elm = (Element)list.item(i);
			if (elm.getAttribute("tagname").equals("anchor")) {
				AnchorTextSegment segment = AnchorTextSegment.restore(elm,spread);
				String segmentURI = segment.getURI();
				doc.addTextSegment(segment);
				segment.setSmartDocument(doc);
				String regionURI = URIObject.HEADER + segmentURI.substring(segmentURI.indexOf(URIObject.SEP4 + URIObject.ANCHOR) +1);
				AnchorRegion region = (AnchorRegion)spread.getRegionByURI(regionURI);
				segment.setAnchorRegion(region);
				if (region != null) {
					region.setAnchorTextSegment(segment);	
				}
			} else {
				TextSegment segment = TextSegment.restore(elm);
				doc.addTextSegment(segment);
				segment.setSmartDocument(doc);
			}
		}
		return doc;	
	}
	
	public static Spread getSpread(SpreadDirectory parent,File parentpath,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String[] token = GSStandardPath.standardizeDirName(element.getAttribute("filename")).split("/");
		String imageFileName = token[token.length-1];
		File filepath = new File(parentpath,imageFileName);
		Spread spread = new Spread(parent,filepath,uri,originalURI,version);
		spread.setOldVersionURI(oldVersionURI);
		spread.setName(name);

		spread.setFirstIDATName(element.getAttribute("firstIDATName"));
		spread.setSecondIDATName(element.getAttribute("secondIDATName"));
		spread.setThirdIDATName(element.getAttribute("thirdIDATName"));
	
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("region")){
					Region region = XML2ResourceConverter.getRegion(spread, elem);
					spread.addRegion(region);
				}else if(tagname.equals("spreadDocument")){
					IDAT iDAT = getIDAT(spread,elem);
					if(iDAT.getType() == GSConstants.SECONDIDAT){
						spread.setSecondIDAT((SecondIDAT)iDAT);
					}else if(iDAT.getType() == GSConstants.FIRSTIDAT){
						spread.setFirstIDAT((FirstIDAT)iDAT);
					}else if(iDAT.getType() == GSConstants.THIRDIDAT){
						spread.setThirdIDAT((ThirdIDAT)iDAT);
					}
				}
			}
		}
		return spread;
	}
	public static TextSegment getTextSegment(Element element,Spread spread){
		String tagname = element.getAttribute("tagname");
		String id = element.getAttribute(GSResource.ID);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		if (tagname.equals("anchor")) {
			AnchorTextSegment segment = new AnchorTextSegment(new Integer(id),uri,originalURI,version);
			String anchorURI = URIObject.HEADER + uri.substring(uri.indexOf(URIObject.SEP4 + URIObject.ANCHOR) +1);
			AnchorRegion region = (AnchorRegion)spread.getRegionByURI(anchorURI);
			segment.setAnchorRegion(region);
			region.setAnchorTextSegment(segment);
			return segment;
		} else {
			TextSegment segment = new TextSegment(tagname,new Integer(id),uri,originalURI,version);
			segment.setOldVersionURI(oldVersionURI);
			return segment;
		}
	}
	
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		NodeList list = element.getElementsByTagName("segment");
		StandardTextDocument doc = new StandardTextDocument(source,name,uri,originalURI,version);
		doc.setOldVersionURI(oldVersionURI);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			doc.addTextSegment(segment);
			segment.setSmartDocument(doc);
		}
		return doc;
		
	}
	

	public static UsersNote getUsersNote(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		if(!source.startsWith("<xml><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(source);
				source = convertGS.parser();
				if(source.equals("")){
					source = "<xml><html></html></xml>";
				}else{
					source = "<xml><html>" + source + "</html></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		NodeList list = element.getElementsByTagName("segment");
		UsersNote usersNote = new UsersNote();
		usersNote.setSource(source);
		usersNote.setURIs(uri, originalURI);
		usersNote.setOldVersionURI(oldVersionURI);
		usersNote.setVersion(version);
		usersNote.setName(name);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			usersNote.addTextSegment(segment);
			segment.setSmartDocument(usersNote);
		} 
		return usersNote;
	}
	
	public Zombie getZombie(Element element) {
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String deadURI = element.getAttribute("deadURI");
		Zombie zombie = new Zombie(deadURI);
		zombie.setURI(uri);
		zombie.setDeadURI(deadURI);
		zombie.setOriginalURI(originalURI);
		zombie.setVersion(version);
		return zombie;
	}
}