/* $Id: SearchResultViewer.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import sml_editor.logical.LineDirection;

@SuppressWarnings("serial")
public class SearchResultViewer extends JFrame{
	
	private List<SearchResult> results;
	private List<SearchResult> newResults;
	private AbstractSearchResultPanel resultPanel;
	private JScrollPane scrollPane;
	private GSQuery query;
	// 20110423 shayashi
	private Image queryImage;
	private QueryBucket bucket;
	protected List<SearchResult> selectedResults;
	private JPanel mainPanel;
	/*"Bucket"
	 * 20071109 c
	 * 폜ꂽ̃Xgǉ
	 */
	protected List<SearchResult> removedResults;
	BucketFrame bucketFrame;
	
	private static int pSize;	
	
	//y[W̕\
	private String searchedPage;
	
	public SearchResultViewer(QueryBucket bucket,List<SearchResult> results){
		super("Search Result");
		this.bucket = bucket;
		this.results = results;
		 // 20071110 c
		this.removedResults = new ArrayList<SearchResult>();
		pSize = bucket.size();
		/*
		 * VȌʂ
		 */
		this.newResults = new ArrayList<SearchResult>();
		for (int i = 0; i < results.size(); i++) {
		    if (!results.get(i).wasShown()) {
			newResults.add(results.get(i));
		    }
		}
		
		this.query = this.bucket.get(0);
		this.selectedResults = new ArrayList<SearchResult>();
		
		this.checkDuplicate();
		
		this.queryImage = this.query.getQueryImageWithTransformation();
		this.build(queryImage);
			
		int size = this.bucket.size();
		
		bucketFrame = new BucketFrame(this.bucket,"Bucket",this.results, removedResults, size);
		bucketFrame.pack();

		this.setLocation(50,100);
		this.pack();
		bucketFrame.setVisible(true);
	}
	//2007/10/11 kazuhiro kobayashi 
	//Ώۂ̃y[W\RXgN^
	public SearchResultViewer(QueryBucket bucket,List<SearchResult> results, String searchedPage){
		this(bucket, results);
		this.searchedPage = searchedPage;
		
	}
	/*
	 * 20071121 c
	 * ̌̃oPbg̃TCY𓾂
	 */ 
	public int getPreviousBucketSize() {
	    return pSize;
	}
	public List<SearchResult> getResults() {
		return results;
	}
	public List<SearchResult> getNewResults() {
	    return newResults;
	}
	
	// 20071109 c
	public List<SearchResult> getRemovedResults() {
	    return removedResults;
	}
	
	public void setResultPanel(AbstractSearchResultPanel resultPanel) {
		mainPanel.remove(this.scrollPane);
		this.resultPanel = resultPanel;
		this.scrollPane.setViewportView(resultPanel);
		mainPanel.add(this.scrollPane,BorderLayout.CENTER);
	}
	private void checkDuplicate(){
		for(int i=0;i<this.bucket.size();i++){
			Rectangle rect = this.bucket.get(i).getRectangle();
			Spread spread = this.bucket.get(i).getSpread();
			Point2D center = new Point2D.Double(rect.getCenterX(),rect.getCenterY());
			if(spread == null){
				continue;
			}
			for(int j=0;j<this.results.size();j++){
				Rectangle rect2 = this.results.get(j).getRectangle();
				Spread spread2 = this.results.get(j).getSpread();
				if(spread.equals(spread2) && rect2.contains(center)){
					this.results.get(j).setIsInBucket(true);
				}
			}
		}
	}
	public List<SearchResult> getSelectedResults() {
		return this.selectedResults;
	}
	public QueryBucket getBucket(){
		return this.bucket;
	}
	private void build(Image queryImage){
		LineDirection lineDirection = query.getSpread().getLineDirection();

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		JPanel queryPanel = new QueryPanel(queryImage,bucket.getLineDirection());
		
		this.scrollPane = new JScrollPane();
//		if (lineDirection == LineDirection.HORIZONTAL) {
			this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
//			this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
//		} else {
			this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
//			this.scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
//		}

		this.resultPanel = new SearchResultPanelOfSegmentMode(this,this.results,queryImage,lineDirection);
		
		this.scrollPane.setViewportView(this.resultPanel);
		
		mainPanel = new JPanel();
		
		JPanel buttonPanel = new JPanel();
		JButton back = new JButton("back");
		back.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultPanel.back();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		JButton next = new JButton("next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				resultPanel.next();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});

		buttonPanel.add(back);
		buttonPanel.add(next);
		
		mainPanel.setLayout(new BorderLayout());
		//2007/10/15 kazuhiro kobayashi y[W\邽
//		mainPanel.add(queryPanel,BorderLayout.NORTH);
		/*
		 * y[W̕\
		 */
		JPanel topPanel = new JPanel();
		topPanel.add(queryPanel);
		
		if (lineDirection == LineDirection.HORIZONTAL) {
			mainPanel.add(topPanel, BorderLayout.NORTH);
		} else {
			mainPanel.add(topPanel, BorderLayout.WEST);
		}
		
		
		mainPanel.add(this.scrollPane,BorderLayout.CENTER);

		
		
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		
		JPanel northPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		northPanel.add(new SearchMenuBar(this,lineDirection));
		JButton transcriptionMode = new JButton("Transcription Tool No1");
		transcriptionMode.addActionListener(new TranscriptionToolNo1Action(queryImage,results,lineDirection));
		northPanel.add(transcriptionMode);
		
		this.getContentPane().add(northPanel,BorderLayout.NORTH);

		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.pack();
	}
	

	public void updateBucket(boolean deleting) {
	    if (deleting) {
		this.removeBucket();
	    } else {
		this.addBucket();
	    }
	}
	
	private void removeBucket() {
	    GSQuery lastQuery = this.bucket.get(this.bucket.size() - 1);
	    Rectangle rect = lastQuery.getRectangle();
	    Spread spread = lastQuery.getSpread();
	    Point2D center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
	    for (int j = 0; j < this.results.size(); j++){
		Rectangle rect2 = this.results.get(j).getRectangle();
		Spread spread2 = this.results.get(j).getSpread();
		if (spread.equals(spread2) && rect2.contains(center)){
		    this.results.get(j).setIsInBucket(false);
		}
	    }
	    this.resultPanel.updateBucket();
	}

	public void addBucket(){
		GSQuery lastQuery = this.bucket.get(this.bucket.size()-1);
		Rectangle rect = lastQuery.getRectangle();
		Spread spread = lastQuery.getSpread();
		Point2D center = new Point2D.Double(rect.getCenterX(),rect.getCenterY());
		for(int j=0;j<this.results.size();j++){
			Rectangle rect2 = this.results.get(j).getRectangle();
			Spread spread2 = this.results.get(j).getSpread();
			if(spread.equals(spread2) && rect2.contains(center)){
				this.results.get(j).setIsInBucket(true);
			}
		}
		this.resultPanel.updateBucket();
	}
	// 20071109 c -- 폜̍XV
	public void updateRemoved() {
	   this.bucketFrame.setRemovedResults(this.removedResults);
	}
	// 20110423 shayashi
	public Image getQueryImage() {
		return queryImage;
	}
}
