package smart_gs.logical;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.view.FreeLineView;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;


public class XML2ResourceConverter {
	
	
	public static GSResource convert(Element element){
		String tagname = element.getNodeName();
		
		if(tagname.equals("note")){
			return getNote(element);
		}else if(tagname.equals("standardDocument")){
			return getStandardDocument(element);
		//1028 shimizu wrote;
		}else if(tagname.equals("presentation")){
			return getPresentation(element);
		}else{
			String uri = element.getAttribute("uri");
			return URISolver.getRegion(uri);
		}
	}
	
	public static Region getRegion(Spread spread,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		//kazuhiro kobayashi 10/7
		String  protection = element.getAttribute("protection");
		
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("view")){
					String type = elem.getAttribute("type");
					View view = null;
					if(type.equals("rect")){
						view = RectangleView.restore(elem);
						Region region = new Region(spread,view);
						region.setName(name);
						region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals("marker")){
						view = MarkerView.restore(elem);
						Region region = new Region(spread,view);
						region.setName(name);
						region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals("line")){
						view = LineView.restore(elem);
						Region region = new Region(spread,view);
						region.setName(name);
						region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}else if(type.equals("lasso")){
						view = FreeLineView.restore(elem);
						Region region = new Region(spread,view);
						region.setName(name);
						region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						return region;
					}
				}
				
			}
		}
		return null;
	}
	
	public static SpreadDocument getSpreadDocument(Element element){
		String type = element.getAttribute("type");
		String leftSource = element.getAttribute("leftSource");
		if(!leftSource.startsWith("<xml><left><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(leftSource);
				leftSource = convertGS.parser();
				if(leftSource.equals("")){
					leftSource = "<xml><left><html></html></left></xml>";
				}else{
					leftSource = "<xml><left><html>" + leftSource + "</html></left></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		String rightSource = element.getAttribute("rightSource");
		if(!rightSource.startsWith("<xml><right><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(rightSource);
				rightSource = convertGS.parser();
				if(rightSource.equals("")){
					rightSource = "<xml><right><html></html></right></xml>";
				}else{
					rightSource = "<xml><right><html>" + rightSource + "</html></right></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		String uri = element.getAttribute("uri");
		SpreadDocument doc = null;
		if(type.equals(GSConstants.TRANSCRIPTION+"")){
			doc = new TranscriptionDocument(uri);
		}else if(type.equals(GSConstants.ANNOTATION+"")){
		    doc = new AnnotationDocument(uri);

		}else if(type.equals(GSConstants.TRANSLATION+"")){
			doc = new TranslationDocument(uri);

		}
		doc.setLeftSource(leftSource);
		doc.setRightSource(rightSource);
		NodeList list = element.getElementsByTagName("segment");
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			doc.addTextSegment(segment);
			segment.setSmartDocument(doc);
		}
		return doc;	
	}
	
	public static Spread getSpread(SpreadDirectory parent,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String filename = element.getAttribute("filename");
		Spread spread = new Spread(parent,new File(filename));
		spread.setURI(uri);
		spread.setName(name);
	
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("region")){
					Region region = XML2ResourceConverter.getRegion(spread, elem);
					spread.addRegion(region);
				}else if(tagname.equals("spreadDocument")){
					SpreadDocument document = getSpreadDocument(elem);
					document.setSpread(spread);
					if(document.getType() == GSConstants.ANNOTATION){
						spread.setAnnotation((AnnotationDocument)document);
					}else if(document.getType() == GSConstants.TRANSCRIPTION){
						spread.setTranscription((TranscriptionDocument)document);
					}else if(document.getType() == GSConstants.TRANSLATION){
						spread.setTranslation((TranslationDocument)document);
					}
				}
			}
		}
		return spread;
	}
	public static TextSegment getTextSegment(Element element){
		String tagname = element.getAttribute("tagname");
		String id = element.getAttribute(GSResource.ID);
		String uri = element.getAttribute(GSResource.URI);
		
		return new TextSegment(tagname,new Integer(id),uri);
	}
	
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		NodeList list = element.getElementsByTagName("segment");
		StandardTextDocument doc = new StandardTextDocument(source,uri,name);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			doc.addTextSegment(segment);
			segment.setSmartDocument(doc);
		}
		return doc;
		
	}
	
	public static Note getNote(Element element){
		Note note = new Note();
		String name = element.getAttribute("name");
		note.setName(name);
		NodeList elements = element.getElementsByTagName("region");
		if(elements.getLength() <= 0){
			return null;
		}
		for(int i=0;i<elements.getLength();i++){
			Element elem = (Element)elements.item(i);
			String uri = elem.getAttribute("uri");
			Region region = URISolver.getRegion(uri);
			note.addRegion(region);
		}
		return note;
	}
	public static Presentation getPresentation(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		if(!source.startsWith("<xml><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(source);
				source = convertGS.parser();
				if(source.equals("")){
					source = "<xml><html></html></xml>";
				}else{
					source = "<xml><html>" + source + "</html></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		NodeList list = element.getElementsByTagName("segment");
		Presentation present = new Presentation();
		present.setName(name);
		present.setURI(uri);
		present.setSource(source);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			present.addTextSegment(segment);
			segment.setSmartDocument(present);
		}
		return present;
	}
}
