package smart_gs.logical;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import smart_gs.SmartGS;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;

public class Preference {
	
	private static Preference singleton = new Preference();
	
	private String userName;
	//2007/10/7 kazuhiro kobayashi
	private String gsFolderPath;
	//2007/1010 kazuhiro kobayashi
	/*
	 * ̃t@CpathÕtH_Ɏwł悤ǉ
	 */
	private String imageFolderPath;
	private String textFolderPath;
	private String dscFolderPath;
	private String lineFolderPath;
	private String smart_gsFolderPath;
	// ADD NorthGrid
	private String smart_exportFolderPath;
	//
	private String defaultGsFilePath;

	//2007/11/20 kazuhiro kobayashi
	private String nameCorrespondenceFilePath;
	
	//2007/12/8 kazuhiro kobayshi
	private String RWBackgroundFilePath;
	
	private boolean shouldLoadAll = false;
	// 20090123 NorthGrid
	// 0 = [Jt@C
	// 1 = WebDav
	private int filemode = 0;
	
	// 20090123 NorthGrid
	private String webdavServerPath;
	private String webdavUserName;
	private String webdavPassword;
	
	// 20090222
	private String browser;
	
	private Preference(){
		this.userName = "default user";
	}
	
	public static Preference getInstance(){
		return singleton;
	}
	
	public boolean shouldLoadAll(){
		return this.shouldLoadAll;
	}
	public void setShouldLoadAll(boolean shouldLoadAll) {
		this.shouldLoadAll = shouldLoadAll;
	}
	
	public String getUserName(){
		return this.userName;
	}
	public void setUserName(String userName){
		this.userName = userName;
	}
	
	
	
	public void load(){
		try {
			Properties properties = new Properties();
			//
//			FileInputStream inStream = new FileInputStream(new File("preference.txt"));
//			properties.load(inStream);
			FileInputStream inStream = new FileInputStream(new File("preference.xml"));
			properties.loadFromXML(inStream);
			//
			this.userName = properties.getProperty("userName");
			int max = new Integer(properties.getProperty("search_max"));
			GSSearchEngine.getInstance().setMaxFound(max);
			
			//20090118 North Grid add
			String searchEngineString = properties.getProperty("image_seatch_engine");
			int searchEngine = searchEngineString == null ? 0 : new Integer(searchEngineString);
			if( searchEngine == 0 ){
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}else{
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
			
			//20080715 shimizu wrote
			int searchType = new Integer(properties.getProperty("search_type"));
			GSSearchEngine.getInstance().setSearchType(searchType);
			int textType = new Integer(properties.getProperty("text_type"));
			TextType.setTextType(textType);
			//2007/10/7 kazuhiro kobayashi
			this.gsFolderPath = properties.getProperty("gsFolderPath");
			//2007/10/10n kazuhiro kobayashi
			this.imageFolderPath = properties.getProperty("imageFolderPath");
			this.textFolderPath = properties.getProperty("textFolderPath");
			this.dscFolderPath = properties.getProperty("dscFolderPath");
			this.lineFolderPath = properties.getProperty("lineFolderPath");
			//2007/10/11
			this.smart_gsFolderPath = properties.getProperty("smart_gsFolderPath");
			// ADD NorthGrid
			this.smart_exportFolderPath = properties.getProperty("smart_exportFolderPath");
			//2007/11/20 kazuhiro kobayashi
			this.nameCorrespondenceFilePath = properties.getProperty("nameCorrespondenceFilePath");
			//2007/11/27 kazuhiro kobayshi
			this.defaultGsFilePath = properties.getProperty("defaultGsFilePath");
			//2007/12/8 kazuhiro kobayshi
			this.RWBackgroundFilePath = properties.getProperty("RWBackgroundFilePath");
			// 2009/01/23 NorthGrid
			try{
				this.filemode = Integer.parseInt(properties.getProperty("file_mode"));
			}catch(NumberFormatException e){}
			
			this.webdavServerPath = properties.getProperty("WebDavServerPath");
			this.webdavUserName   = properties.getProperty("WebDavUserName");
			this.webdavPassword   = properties.getProperty("WebDavPassword");
			
			this.browser = properties.getProperty("browser");
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	public void save() {
		Properties properties = new Properties();
		properties.put("userName", this.userName);
		int max = GSSearchEngine.getInstance().getMaxFound();
		properties.put("search_max",max+"");

		//20090118 North Grid add
		if( GSSearchEngine.getInstance().isUseExternalEngine() ){
			properties.put("image_seatch_engine","0");
		}else{
			properties.put("image_seatch_engine","1");
		}
		
		int searchType = GSSearchEngine.getInstance().getSearchType();
		properties.put("search_type",searchType+"");
		//20080715 shimizu wrote
	    int textType = TextType.getTextType();
		properties.put("text_type", textType+"");
		//2007/10/7 kazuhiro kobayashi
		if(this.gsFolderPath!=null){
			properties.put("gsFolderPath", this.gsFolderPath);
		}
		//2007/10/10 kazuhiro kobayashi
		if(this.imageFolderPath!=null){
			properties.put("imageFolderPath", this.imageFolderPath);
		}
		if(this.textFolderPath!=null){
			properties.put("textFolderPath", this.textFolderPath);
		}
		if(this.dscFolderPath!=null){
			properties.put("dscFolderPath", this.dscFolderPath);
		}
		if(this.lineFolderPath!=null){
			properties.put("lineFolderPath", this.lineFolderPath);
		}
		//2007/10/11
		if(this.smart_gsFolderPath!=null){
			properties.put("smart_gsFolderPath", this.smart_gsFolderPath);
		}
		//2007/11/20 kazuhiro kobayashi
//		if(this.nameCorrespondenceFilePath!=null){
			properties.put("nameCorrespondenceFilePath", this.nameCorrespondenceFilePath);
//		}
		//2007/11/27 kazuhiro kobayashi
//		if(this.defaultGsFilePath!=null){
			properties.put("defaultGsFilePath", this.defaultGsFilePath);
//		}
			//2007/12/8 kazuhiro kobayshi
			properties.put("RWBackgroundFilePath", this.RWBackgroundFilePath);
		
		// 2009/01/23 NorthGrid
		properties.put("file_mode", String.valueOf(this.filemode));
		if(webdavServerPath != null){
			properties.put("WebDavServerPath", webdavServerPath);
		}
		if(webdavUserName != null){
			properties.put("WebDavUserName", webdavUserName);
		}
		if(webdavPassword != null){
			properties.put("WebDavPassword", webdavPassword);
		}
		if(this.browser != null){
			properties.put("browser", browser);
		}
		try {
//			
//			FileOutputStream outStream = new FileOutputStream(new File("preference.txt"));
//			properties.store(outStream,"no comment");
			FileOutputStream outStream = new FileOutputStream(new File("preference.xml"));
			properties.storeToXML(outStream,"no comment");
			//		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	//2007/10/7 kazuhiro kobayashi
	public String getGsFolderPath(){
		return this.gsFolderPath;
	}
	public void setGsFolderPath(String gsFolderPath){
		this.gsFolderPath = gsFolderPath;
	}
	// ADD NorthGrid
	public String getSmart_exportFolderPath() {
		return smart_exportFolderPath;
	}

	public void setSmart_exportFolderPath(String smart_exportFolderPath) {
		this.smart_exportFolderPath = smart_exportFolderPath;
	}
	
	
	//2007/10/11 kazuhiro kobayashi
	public String getImageFolderPath() {
		return imageFolderPath;
	}

	public void setImageFolderPath(String imageFolderPath) {
		
		if(imageFolderPath != null){
			this.imageFolderPath = imageFolderPath ;
		}
	}

	public String getTextFolderPath() {
		return textFolderPath;
	}

	public void setTextFolderPath(String textFolderPath) {
		if(textFolderPath != null){
			this.textFolderPath = textFolderPath ;
		}
	}

	public String getDscFolderPath() {
		return dscFolderPath;
	}

	public void setDscFolderPath(String dscFolderPath) {
		if(dscFolderPath != null){
				this.dscFolderPath = dscFolderPath ;
		}
	}

	public String getLineFolderPath() {
		return lineFolderPath;
	}

	public void setLineFolderPath(String lineFolderPath) {
		if(lineFolderPath != null){
				this.lineFolderPath = lineFolderPath ;
		}
	}
	//2007/11/20 kazuhiro kobayashi
	public void setNameCorrespondencePath(String nameCorrespondencePath){
//		if(nameCorrespondencePath!=null){
			this.nameCorrespondenceFilePath = nameCorrespondencePath;
//		}
	}
	public String getNameCorrespondencePath(){
		return this.nameCorrespondenceFilePath;
	}
	public void setSmart_gsFolderPath(String smart_gsFolderPath){
		this.smart_gsFolderPath = smart_gsFolderPath;
	}
	public String getSmart_gsFolderPath(){
		return this.smart_gsFolderPath;
	}
	//2007/11/27 kazuhiro kobayashi
	public String getDefaultGsFilePath() {
		return defaultGsFilePath;
	}
	public void setDefaultGsFilePath(String defaultGsFolePath) {
		this.defaultGsFilePath = defaultGsFolePath;
	}

	//2007/12/8 kazuhiro kobayshi
	public String getRWBackgroundFilePath() {
		return RWBackgroundFilePath;
	}

	public void setRWBackgroundFilePath(String backgroundFilePath) {
		RWBackgroundFilePath = backgroundFilePath;
	}

	// 2009/01/23 NorthGrid
	public int getFilemode() {
		return filemode;
	}

	public void setFilemode(int filemode) {
		this.filemode = filemode;
	}

	public String getWebdavPassword() {
		return webdavPassword;
	}

	public void setWebdavPassword(String webdavPassword) {
		this.webdavPassword = webdavPassword;
	}

	public String getWebdavServerPath() {
		return webdavServerPath;
	}

	public void setWebdavServerPath(String webdavServerPath) {
		this.webdavServerPath = webdavServerPath;
	}

	public String getWebdavUserName() {
		return webdavUserName;
	}

	public void setWebdavUserName(String webdavUserName) {
		this.webdavUserName = webdavUserName;
	}

	public String getBrowser() {
		return browser;
	}

	public void setBrowser(String browser) {
		this.browser = browser;
	}
}
