package smart_gs.swingui;

import javax.swing.JPopupMenu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.toolbar.action.HTMLFileFilter;
import smart_gs.swingui.toolbar.action.TextFileFilter;
import smart_gs.util.StringUtils;


public class SheetSelectPopupMenu extends JPopupMenu {
	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	
	public SheetSelectPopupMenu(SpreadTree tree){
	
		Spread selectedSpread = tree.getSelectedSpread();
		if(selectedSpread != null){
			//kazuhiro kobayashi 10/3
			//10/4 sheet̖Ot悤ɂB
			List<Sheet> sheets = selectedSpread.getSheets();
			JMenu[] sheetName = new JMenu[sheets.size()];
			for(int i = 0; i < sheets.size(); i++){
				this.setSheetNameItem = new JMenuItem("Set Sheet Name");
				this.showSheetItem = new JMenuItem("Show Sheet");
				 sheetName[i] = new JMenu(sheets.get(i).getSheetName());
				 sheetName[i].add(setSheetNameItem);
				 sheetName[i].add(showSheetItem);
				 this.showSheetItem.addActionListener(new SheetSelectAction(sheets.get(i)));
				 this.setSheetNameItem.addActionListener(new SetSheetNameAction(sheets.get(i)));
				 this.add(sheetName[i]);
			}
			JMenuItem deleteItem = new JMenuItem("Delete Sheet");
			deleteItem.addActionListener(new DeleteSheetAction(tree));
			this.add(deleteItem);
		}else{
			SpreadDirectory spreadDirectory = tree.getSelectedSpreadDirectory();
			if(spreadDirectory != null){
				JMenuItem addItem = new JMenuItem("Add Sheet");
				addItem.addActionListener(new AddSheetAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addItem);
				JMenuItem addDirectory = new JMenuItem("Add Directory");
				addDirectory.addActionListener(new AddDirectoryAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addDirectory);
				JMenuItem deleteItem = new JMenuItem("Delete Directory");
				deleteItem.addActionListener(new DeleteDirectoryAction(tree));
				this.add(deleteItem);
			}
		}
	}
	
	class DeleteSheetAction implements ActionListener{
		SpreadTree tree;
		public DeleteSheetAction(SpreadTree tree ){
			this.tree = tree;
		}
		public void actionPerformed(ActionEvent e) {
			tree.remove();
		}
		
	}
	class DeleteDirectoryAction implements ActionListener{
		SpreadTree tree;
		public DeleteDirectoryAction(SpreadTree tree ){
			this.tree = tree;
		}
		public void actionPerformed(ActionEvent e) {
			tree.removeDirectory();
		}
		
	}
	class AddDirectoryAction extends AddSheetAction{
		
		public AddDirectoryAction(File openDirectory,SpreadTree tree,SpreadDirectory spreadDirectory){
			super(openDirectory, tree, spreadDirectory);
		}
		
		public void actionPerformed(ActionEvent e) {
			JFileChooser chooser = new JFileChooser(openDirectory);
			
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

			int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
			if (input == JFileChooser.CANCEL_OPTION) {
				return;
			}
			File file = chooser.getSelectedFile();
			String imagepath = Preference.getInstance().getImageFolderPath();
			File imageFolder = new File(Preference.getInstance().getImageFolderPath());
			imagepath = StringUtils.replaceString(imagepath, "\\", "/");
			imagepath = StringUtils.replaceString(imagepath, "//", "/");
			
			if(file != null){
				String dir1 = openDirectory.getAbsolutePath();
				String dir2 = imageFolder.getAbsolutePath();
				String dir3 = file.getAbsolutePath();
				dir1 = StringUtils.replaceString(dir1, "\\", "/");
				dir1 = StringUtils.replaceString(dir1, "./", "/");
				dir1 = StringUtils.replaceString(dir1, "//", "/");
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				dir2 = StringUtils.replaceString(dir2, "./", "/");
				dir2 = StringUtils.replaceString(dir2, "//", "/");
				dir3 = StringUtils.replaceString(dir3, "\\", "/");
				dir3 = StringUtils.replaceString(dir3, "./", "/");
				dir3 = StringUtils.replaceString(dir3, "//", "/");
				
				boolean check = true;
				if(!dir1.toLowerCase().startsWith(dir2.toLowerCase())){
					check = false;
				}
				if(!dir3.toLowerCase().startsWith(dir1.toLowerCase())){
					check = false;
				}
				if(!check){
					int answer = JOptionPane.showConfirmDialog(new Frame(), "Only a folder in or below the image folder can be added.  ","Information",JOptionPane.DEFAULT_OPTION);
					return;
				}
				if(!imagepath.endsWith("/")){
					imagepath+="/";
				}
				if(!dir1.equals(dir2)){
					String rootpath = dir1.substring(dir1.indexOf(dir2) + dir2.length() ,dir1.length());
					StringBuffer sb = new StringBuffer();
					boolean delete = true;
					for(int i=0;i<rootpath.length();i++){
						if(delete){
							if(rootpath.charAt(i) != '/'){
								delete = false;
							}
						}
						if(!delete){
							sb.append(rootpath.charAt(i));
						}
					}
					imagepath+=sb.toString();
				}
				if(!imagepath.endsWith("/")){
					imagepath+="/";
				}
				{
					String addPath = dir3.substring(dir3.indexOf(dir1) + dir1.length() ,dir3.length());
					StringBuffer sb = new StringBuffer();
					boolean delete = true;
					for(int i=0;i<addPath.length();i++){
						if(delete){
							if(addPath.charAt(i) != '/'){
								delete = false;
							}
						}
						if(!delete){
							sb.append(addPath.charAt(i));
						}
					}
					file = new File(imagepath + sb.toString());				
				}
				File top = new File(imagepath);
				addAll(top,file);
			}
		}
		
		public void addAll(File top,File parent){
			String dir1 = top.getPath();
			dir1 = StringUtils.replaceString(dir1, "\\", "/");
			dir1 = StringUtils.replaceString(dir1, "//", "/");
			{
				// String dir2 = parent.toString();
				String dir2 = parent.getPath();
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				dir2 = StringUtils.replaceString(dir2, "//", "/");
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				addImage(dir1, dir2,parent);
			}
			File [] list = parent.listFiles();
			for( int i = 0; i < list.length; i++){
				if(list[i].isDirectory()){
					addAll(top,list[i]);
				}else{
					String dir2 = list[i].getPath();
					dir2 = StringUtils.replaceString(dir2, "\\", "/");
					dir2 = StringUtils.replaceString(dir2, "//", "/");
					dir2 = StringUtils.replaceString(dir2, "\\", "/");
					dir2 = dir2.substring(0,dir2.lastIndexOf("/"));
					addImage(dir1, dir2, list[i]);
				}
			}

		}
	}

	class AddSheetAction implements ActionListener{
		protected File openDirectory;
		protected SpreadTree tree;
		protected SpreadDirectory spreadDirectory;
		
		public AddSheetAction(File openDirectory,SpreadTree tree,SpreadDirectory spreadDirectory){
			this.openDirectory = openDirectory;
			this.tree = tree;
			this.spreadDirectory = spreadDirectory;
		}
		
		public void addImage(String rootDir,String addFileDir, File addFile){
			if(tree.isRegistered(addFile)) return;
			
			DefaultMutableTreeNode treeNode = tree.getSelectedNode();
			SpreadDirectory parent = spreadDirectory;
			if(!rootDir.equals(addFileDir)){
				
				//String dir = addFileDir.substring(addFileDir.indexOf(rootDir) + rootDir.length(),addFileDir.length());
				String dir = addFileDir.substring( rootDir.length(),addFileDir.length());
				StringTokenizer st = new StringTokenizer(dir, "/");
				StringBuffer dirBuf = new StringBuffer();
				if(!rootDir.endsWith("/")){
					rootDir+="/";
				}
				dirBuf.append(rootDir);
				
		        while (st.hasMoreTokens()) {
		        	dirBuf.append(st.nextToken() + "/");
		        	File newDir = new File(dirBuf.toString());
		        	
			        treeNode = tree.addDirectory(treeNode, parent, newDir);
			        parent = (SpreadDirectory)treeNode.getUserObject();
		        }
			}
			tree.addLoadImage(treeNode,parent, addFile);
		}
		public void actionPerformed(ActionEvent e) {
			JFileChooser chooser = new JFileChooser(openDirectory);
			
			int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
			if (input == JFileChooser.CANCEL_OPTION) {
				return;
			}
			File file = chooser.getSelectedFile();
			String imagepath = Preference.getInstance().getImageFolderPath();
			File imageFolder = new File(Preference.getInstance().getImageFolderPath());
			imagepath = StringUtils.replaceString(imagepath, "\\", "/");
			imagepath = StringUtils.replaceString(imagepath, "//", "/");
			if(file != null){
				String dir1 = openDirectory.getAbsolutePath();
				String dir2 = imageFolder.getAbsolutePath();
				String dir3 = file.getAbsolutePath();
				dir1 = StringUtils.replaceString(dir1, "\\", "/");
				dir1 = StringUtils.replaceString(dir1, "./", "/");
				dir1 = StringUtils.replaceString(dir1, "//", "/");
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				dir2 = StringUtils.replaceString(dir2, "./", "/");
				dir2 = StringUtils.replaceString(dir2, "//", "/");
				dir3 = StringUtils.replaceString(dir3, "\\", "/");
				dir3 = StringUtils.replaceString(dir3, "./", "/");
				dir3 = StringUtils.replaceString(dir3, "//", "/");
				
				boolean check = true;
				if(!dir1.toLowerCase().startsWith(dir2.toLowerCase())){
					check = false;
				}
				if(!dir3.toLowerCase().startsWith(dir1.toLowerCase())){
					check = false;
				}
				if(!check){
					int answer = JOptionPane.showConfirmDialog(new Frame(), "Only a folder in or below the image folder can be added.  ","Information",JOptionPane.DEFAULT_OPTION);
					return;
				}
				if(!imagepath.endsWith("/")){
					imagepath+="/";
				}
				if(!dir1.equals(dir2)){
					String rootpath = dir1.substring(dir1.indexOf(dir2) + dir2.length() ,dir1.length());
					StringBuffer sb = new StringBuffer();
					boolean delete = true;
					for(int i=0;i<rootpath.length();i++){
						if(delete){
							if(rootpath.charAt(i) != '/'){
								delete = false;
							}
						}
						if(!delete){
							sb.append(rootpath.charAt(i));
						}
					}
					imagepath+=sb.toString();
				}
				if(!imagepath.endsWith("/")){
					imagepath+="/";
				}
				{
					String addPath = dir3.substring(dir3.indexOf(dir1) + dir1.length() ,dir3.length());
					StringBuffer sb = new StringBuffer();
					boolean delete = true;
					for(int i=0;i<addPath.length();i++){
						if(delete){
							if(addPath.charAt(i) != '/'){
								delete = false;
							}
						}
						if(!delete){
							sb.append(addPath.charAt(i));
						}
					}
					file = new File(imagepath + sb.toString());				
				}
				File top = new File(imagepath);
				if(tree.isRegistered(file)){
					JOptionPane.showConfirmDialog(new Frame(), "The selected file has already been being used.  ","Information",JOptionPane.DEFAULT_OPTION);
					return;
				}
				addImage(top.getParent(), file.getPath(), file);
			}
		}
	}
}
