package smart_gs.smleditor.swingui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.drawing_tool.action.SetExternalLinkAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import sml_editor.swingui.EditorTextPane;
 
@SuppressWarnings("serial")
public class GSEditorPopupMenu extends JPopupMenu{
	
	public GSEditorPopupMenu(final TextSegment segment,final EditorTextPane textPane,final Point point,boolean href) {
		JMenuItem setSource = new JMenuItem("Set Link Source");
		setSource.addActionListener(new SetLinkSourceAction(segment));
		if(href){
			setSource.setEnabled(false);
		}
		this.add(setSource);
		
		JMenuItem setTarget = new JMenuItem("Set Link Target");
		setTarget.addActionListener(new SetLinkTargetAction(segment));
		if(href){
			setTarget.setEnabled(false);
		}
		this.add(setTarget);

		JMenuItem setExternal = new JMenuItem("Set External Link");
	    setExternal.addActionListener(new SetExternalLinkAction(segment,textPane,point));
	    if(ConnectionCreator.getSource() != null){
	    	setExternal.setEnabled(false);
	    }
		if(GS_RWRepository.getInstance().hasLink(segment)){
			setExternal.setEnabled(false);
		}
		this.add(setExternal);

		JMenuItem jump = new JMenuItem("Show Local View");
		if(!GS_RWRepository.getInstance().hasLink(segment)){
			jump.setEnabled(false);
		}
		jump.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				new ShowLocalViewAction(segment).execute();
			}
		});
		this.add(jump);

		JMenuItem webjump = new JMenuItem("Show Web Page");
		webjump.addActionListener(new JumpWebPageAction(textPane,point));
		if(!href){
			webjump.setEnabled(false);
		}
		this.add(webjump);

	}
}
