package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSTabbedPaneMamager;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import sml_editor.swingui.EditorTextPane;

import com.hexidec.ekit.GSHTMLEditorFoucsActionListner;
import com.hexidec.ekit.GSHTMLEditorSearchActionListner;


@SuppressWarnings("serial")
public class GSEditor extends AbstractGSWindow{
	
	private GSTabbedPane tabbedPane;
	private GSEditorToolBar gsEditorToolBar;
	// SHOW̔ʗpID
	private String url;
	protected int opne = 0;
	protected long id;
	
//	private GSEditorToolBar editorToolBar;
//	private GSEditorTextPane textPane;
	public GSEditor(Spread spread){
		super("Editor:" + spread.getURI());
		this.url = spread.getURI();
		this.tabbedPane = this.createTabbedPane(spread);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout());
		this.add(this.tabbedPane,BorderLayout.CENTER);
		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		gsEditorToolBar = new GSEditorToolBar(null);
		panel1.add(gsEditorToolBar);
		panel1.add(new ImageToolBar(this));
		panel1.add(new SearchToolBar(this));
		
		this.add(panel1, BorderLayout.NORTH);
		
		this.setSize(900,700);
		
		id = GSTabbedPaneMamager.getControlid();
		this.addWindowListener(new GSTabbedPaneWindowAdapter(this.url,String.valueOf(id),getSMLTabbedPane()));
	}
	
	public GSEditor(Spread spread, Rectangle2D rect) {
		this(spread);
		View view = new RectangleView(rect);
		view.setIsEmphasized(true);
		Point point = new Point((int)rect.getX(),(int)rect.getY());
		this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
		this.tabbedPane.getSpreadCanvas().addTempView(view);
	}
	
	
	public GSEditor(List<SearchResult> results) {
		this(results.get(0).getSpread());
		for(int i=0;i<results.size();i++){
			Rectangle2D rect = results.get(i).getRectangle();
			View view = new RectangleView(rect);
			view.setIsEmphasized(true);
			this.tabbedPane.getSpreadCanvas().addTempView(view);
		}
		Point point = results.get(0).getRectangle().getLocation();
		this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
	}
	/*public GSEditor(Region region) {
		this(region.getSpread(),region.getView().getRectangle2D());
	}
	*/
	
	public GSEditor(Region region){
		this(region.getSpread());
		View view = region.getView();
		view.setIsEmphasized(true);
		Rectangle2D rect = region.getRectangle();
		Point point = new Point((int)rect.getX(),(int)rect.getY());
		this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
		this.tabbedPane.getSpreadCanvas().addTempView(view);
	}
	public GSEditor(TextSegment segment) {
		super("Editor");
	}

	public void setEditorTextPane(EditorTextPane textPane) {
		textPane.setSearchAction(new SearchAction(gsEditorToolBar));
		textPane.setFocusAction(new FoucsAction(this,gsEditorToolBar));
		gsEditorToolBar.setTextPane(textPane);
	}

	public void setEditorToolBar(JToolBar toolbar) {
		
	}
	public Spread getSpread() {
		return this.tabbedPane.getSpread();
	}
	public GSTabbedPane getSMLTabbedPane(){
		return this.tabbedPane;
	}
	public static void main(String[] args) {
		
	}
	@Override
	public void updateGUI(Spread spread) {
		validate();
	}
	@Override
	public SpreadCanvas getSpreadCanvas() {
		return this.tabbedPane.canvas;
	}
	public Frame getFrame() {
		return this;
	}
	@Override
	public GSTabbedPane createTabbedPane(Spread spread) {
		return new GSTabbedPane(this,spread);
	}
	public void emphasize(String id) {
		this.tabbedPane.emphasize(id);
	}
	public void updateText() {
		this.tabbedPane.updateText();
	}

	public String getURL(){
		return url;
	}
	
	public long getControlid(){
		return id;
	}
	public 	GSEditorToolBar getGSEditorToolBar(){
		return this.gsEditorToolBar;
	}
	
	// 20080916 hashimoto.
	// ݑIĂ^uŁAJ[\^ꂽCfbNXɈړ郁\bh
	public void setCaret(int index){
		getSMLTabbedPane().setCaret(index);
	}

	class GSTabbedPaneWindowAdapter extends WindowAdapter{
		protected String key;
		protected String id;
		protected GSTabbedPane gsTabbedPane;
		public GSTabbedPaneWindowAdapter(String key,String id,GSTabbedPane gsTabbedPane){
			this.key = key;
			this.id = id;
			this.gsTabbedPane = gsTabbedPane;
		}
        public void windowClosing(WindowEvent e) {
        }
        public void windowActivated(WindowEvent e) {
			// EBhE̐ݒ
			SearchDialogManager.setGSEditorToolBar(getGSEditorToolBar());
			GSTabbedPane newTabbedPane = GSTabbedPaneMamager.getGSTabbedPane(key);
        	if(newTabbedPane != null){
        		String windowid = GSTabbedPaneMamager.getWindowsID(key);
        		if(windowid == null){
        			return;
        		}
        		if(windowid.equals(key + id)){
        			return;
        		}
        		newTabbedPane.save();
	        	String transcriptionSource = newTabbedPane.getTranscriptionSource();
	        	this.gsTabbedPane.updateTranscription(transcriptionSource);

	        	String annotationSource = newTabbedPane.getAnnotationSource();
	        	this.gsTabbedPane.updateAnnotation(annotationSource);

	        	String translationSource = newTabbedPane.getTranslationSource();
	        	this.gsTabbedPane.updateTranslation(translationSource);

	        	this.gsTabbedPane.updateText();
	        	this.gsTabbedPane.save();
	        	GSTabbedPaneMamager.removeGSTabbedPane(key);
        	}
        	opne = 1;
//        	System.out.println("ANeBu:" + key);
        }

        public void windowDeactivated(WindowEvent e) {
        	this.gsTabbedPane.save();
        	GSTabbedPaneMamager.setGSTabbedPane(key, key + id ,gsTabbedPane);
        }
        public void windowClosed(WindowEvent e) {
        	opne = 2;
        	GSTabbedPaneMamager.close(key + id);
        }
	}
	
	public int isOpened(){
		return opne;
	}

	private class SearchAction implements GSHTMLEditorSearchActionListner{
		protected GSEditorToolBar gsEditorToolBar;
		public SearchAction(GSEditorToolBar gsEditorToolBar) {
			this.gsEditorToolBar = gsEditorToolBar;
		}
		public void actionPerformed() {
			SearchDialogManager.setGSEditorToolBar(gsEditorToolBar);
			SearchDialogManager.visible();
		}
	}

	private class FoucsAction implements GSHTMLEditorFoucsActionListner{
		protected GSEditorToolBar gsEditorToolBar;
		protected GSEditor gsEditor;
		public FoucsAction(GSEditor gsEditor,GSEditorToolBar gsEditorToolBar) {
			this.gsEditor = gsEditor; 
			this.gsEditorToolBar = gsEditorToolBar;
		}
		public void focusGained() {
			SearchAllDialogManager.setEditor(gsEditor, gsEditorToolBar);
			SearchDialogManager.setGSEditorToolBar(gsEditorToolBar);
		}
		public void focusLost() {
			
		}
	}


}
